library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity gray_to_plus3 is
port
(
	gray_code	:  in	std_logic_vector (4 downto 1);
	plus3_code	:  out	std_logic_vector (4 downto 1);
	ostatne_segmenty  :  out 	std_logic_vector (11 downto 0)
	);
end entity gray_to_plus3;

architecture gray_tabulka of gray_to_plus3 is
begin
	ostatne_segmenty  <= "111111111111";

	process (gray_code)
	begin
		case gray_code is
			when "0000" => plus3_code <= "1100";
			when "0001" => plus3_code <= "1011";
			when "0011" => plus3_code <= "1010";
			when "0010" => plus3_code <= "1001";
			when "0110" => plus3_code <= "1000";
			when "0111" => plus3_code <= "0111";
			when "0101" => plus3_code <= "0110";
			when "0100" => plus3_code <= "0101";
			when "1100" => plus3_code <= "0100";
			when "1101" => plus3_code <= "0011";
			when others => plus3_code <= "1111";
		end case;
	end process;
end architecture gray_tabulka;