/*
   WRAP_TEST.C
   Kod demonstruje funkcnost (po spravnom kodovani v jazyku C) tejto vlastnosti C-prekladaca
   pre neznamienkove cisla (pre jednoduchost v kode predpokladame 8-bitovy citac):

   http://www.thetaeng.com/designIdeas/TimerWrap.html

   Kod prepdpoklada inkrementovanie citaca a pretecenie po dosiahnuti maximalnej hodnoty spat na 0.
   V pripade, ze je citac hardverovo dekrementovany, je potrebne zmenit podmienku
   z
         if ( (cnt) (counter - actual) >= DELAY ) { // tato verzia funguje spravne
   na
         if ( (cnt) (actual - counter) >= DELAY ) { // tato verzia funguje spravne


   M. Drutarovsky, v. 1.00, 2017-03-10, PVS, KEMT FEI TUKE
*/



#include <stdio.h>
#include <stdint.h>


#define   PRETYPOVANIE             // bez pretypovania kod nefunguje spravne (pre uint8_t a uint16_t v gcc)!!!
#define   DELAY         (20)       // hodnota meraneho oneskorenia
#define   START         (~0)       // nastavenie citaca na maximalnu hodnotu (0xFF...)

// pre demonstraciu je vyuzity priklad s 8-bitovym citacom, pre 16- a 32-bitovy citac treba zmenit typ 
typedef   uint8_t       cnt;       // unit8_t, uint16_t, uint32_t pre 8-, 16-, 32- bitovy citac

int main(void)
{
  cnt  actual,  counter;           // actual - hodnota citaca (counter) na zaciatku merania oneskorenia
  int k;

    counter = START-DELAY/2;       // simulujeme zaciatok merania tesne pred stavom pretecenia citaca
    actual = counter;              // simulujeme meranie oneskorenia pre aktualny stav citaca
    printf("\nStart merania oneskorenia %u od hodnoty Counter=0x%x", (unsigned int) DELAY, (unsigned int) counter);

    printf("\nSTART: Counter= 0x%x", (unsigned int) counter);
    k = 256;                       // simuluje vsetkych 256 stavov 8-bitoveho citaca
    while( k-- ) {

#ifdef PRETYPOVANIE
         if ( (cnt) (counter - actual) >= DELAY ) { // tato verzia funguje spravne (plati pre inkrementovanie citaca)
#else
         if ( (counter - actual) >= DELAY ) {           // nefunguje, kedze C prekladac pretypuje
#endif                                                  // operandy a vysledok do int aritmetiky
             printf("\nSTOP: Counter= 0x%x", (unsigned int) counter);
             return 0;
         }
         counter++;                // counter--; ak je citac HW dekerementovany
         if (counter==0)
             printf("\nPretecenie citaca");
    }

    printf("\nNEFUNGUJE!!!");      // indikuje, ze nedoslo k spravnej signalizacii oneskorenia DELAY

    return 1;
}



