#include <stdio.h>
#include "mini-gmp.h"


/* Free memory allocated via mini-gmp allocation function. */
static void
testfree (void *p)
{
  void (*freefunc) (void *, size_t);
  mp_get_memory_functions (NULL, NULL, &freefunc);

  freefunc (p, 0);
}

static void
dump (const char *label, const mpz_t x)
{
  char *buf = mpz_get_str (NULL, 16, x);
  fprintf (stderr, "%s: %s\n", label, buf);
  testfree (buf);
}

int main(void) {
 mpz_t x,y,result;

 mpz_init_set_str(x, "7612058254738945", 10);
 mpz_init_set_str(y, "9263591128439081", 10);
 mpz_init(result);

 mpz_mul(result, x, y);
#if (0)
 gmp_printf("    %Zd\n"
            "*\n"
            "    %Zd\n"
            "--------------------\n"
            "%Zd\n", x, y, result);
 #endif
            dump ("x", x);
	    dump ("y", y);
            dump ("result", result); 

 /* free used memory */
 mpz_clear(x);
 mpz_clear(y);
 mpz_clear(result);
 return 0;
}
