% Jednoducha demonstracia vyuzitia Matlabu na detekciu signalu v zasumenom
% signale. "Vstupny signal" je vytvoreny zmesou harmonickeho signalu s
% nahodnym posunutim a aditivneho sumu s gausovskym rozlozenim hustoty
% pravdepodobnosti.
% Detekcia je realizovana pomocou "korelacneho" principu, t.j. s vyuzitim
% informacie o detekovanom signale.
% Hlavnym zmyslom demonstracie je naznacit vyhody a jednoduchost vyuzitia
% zakladnych prikazov Matlabu. Uvedeny princip vsak ma aj prakticke
% vyuzitie v realnych konstrukciach elektronickych a telekomunikacnych
% zariadeni.
% Vyuzite su len zakladne poznatky z predmetu signaly a sustavy.
%
% PPET, M.D. 20-03-2007, v.1.01

fvz = 10000;       % vzorkovacia frekvencia
fsig = 200;        % fekvencia "uzitocneho" harmonickeho signalu
Asig = 1.0;        % amplituda "uzitocneho" harmonickeho signalu
Asum = 2.0;        % parameter urcujuci amplitudu sumu (!!! nie je to
                   % priamo amplituda)

N = 1024;          % celkova dlzka (pocet vzoriek) analyzovaneho signalu
T = 100;           % dlzka (pocet vzoriek) uzitocneho signalu

% generovanie a zobrazenie "uzitocneho" signalu
sig = Asig*sin(2*pi*fsig*(0:T-1)/fvz);	% generovanie

figure(1);         % zobrazenie bude v samostatnom okne c.1
plot(sig);         % prikaz na zobrazenie
title('Uzitocny signal');               % popis obrazku
xlabel('Diskretny cas');
ylabel('Amplituda');
grid;              % zapnutie mriezky v zobrazenom obrazku

pause;             % docasne zastavenie vypoctu, caka sa Enter

% definovanie "nahodnej" polohy uzitocneho signalu v celkovom (N-vzorkovom)
% zazname
pol = round(1+ rand(1)*(N-T));	% poloha zaciatku
in = [ zeros(1,pol) sig ];      % "vlozenie" uzitocneho signalu (od pol+1)
in(N) = 0;                      % dodefinovanie celkovej dlzky zaznamu

figure(2);         % zobrazenie bude v samostatnom okne c.2
plot(in);          % prikaz na zobrazenie
title('Nahodne posunuty uzitocny signal');  % popis obrazku
xlabel('Diskretny cas');
ylabel('Amplituda');
grid;              % zapnutie mriezky v zobrazenom obrazku

pause;

% generovanie zasumeneho signalu (aditivna zmes in + Gaussov sum)
sum = Asum*randn(1,N); % vygenerovanie gausovskeho sumu
in_sum = in + sum; % aditivna zmes posunuteho signalu a sumu

figure(3);         % zobrazenie bude v samostatnom okne c.3
plot(in_sum);          % prikaz na zobrazenie
title('Zasumeny posunuty uzitocny signal');  % popis obrazku
xlabel('Diskretny cas');
ylabel('Amplituda');
grid;              % zapnutie mriezky v zobrazenom obrazku

pause;

% Vypocet KORELACIE medzi (vektormi) sig a in_sum. Vypocet je realizovany
% velmi neefektivne len s vyuzitim zakladnych prikazov Matlabu.
% Pocas prednasok a cviceni budu analyzovane efektivnejsie metody,
% ako je mozne tento vypocet v Matlabe realizovat.

out = zeros(1,N-T+1);  % nie je to nutne, ale alokacia moze zrychlit vypocet
for k=1:(N-T+1)    % cyklus v Matlabe
   out(k) = sig*in_sum(k:k+T-1)';   % vypocet korelacie pre posun "k"
end

figure(4);         % zobrazenie bude v samostatnom okne c.4
plot(out);         % prikaz na zobrazenie
title('Vystup korelacneho prijimaca');  % popis obrazku
xlabel('Posun');
ylabel('Amplituda');
grid;              % zapnutie mriezky v zobrazenom obrazku

[m,odhad] = max(out);  % najdenie maxima
pol = pol+1;       % realny zaciatok je posunuty o 1
pol                % presna poloha zaciatku (definovana pri generovani)
odhad              % odhad polohy pomocou korelacneho prijimaca



