% Demonstracia vyuzitia komplexneho signalu v SDR (Software Defined Radio).
% Naznaceny princip je typicky vyuzivany vo vstupnych castiach prijimacov.
% Pre jednoduchost bude naznaceny len princip detekcie AM a FM signalov.
%
% Hlavnym cielom je naznacenie realnych vyhod "komplexych" signalov ,,:-)
%
% PPET, M.D. 27-03-2007, v.1.0

fvz = 10000;       % vzorkovacia frekvencia
fsig = 200;        % fekvencia "uzitocneho" harmonickeho signalu
Asig = 1.0;        % amplituda "uzitocneho" harmonickeho signalu

N = 1024;          % celkova dlzka (pocet vzoriek) analyzovaneho signalu

load h.dat         % nacitanie koeficientov FIR filtra (HILBERTOV filter)
figure(1);         % zobrazenie bude v samostatnom okne c.1
subplot(2,1,1);
plot(h);           % prikaz na zobrazenie
title('Impulzova odpoved Hilbertovho FIR filtra');     % popis obrazku
xlabel('Diskretny cas');
ylabel('Amplituda');
grid;              % zapnutie mriezky v zobrazenom obrazku

pause;             % docasne zastavenie vypoctu, caka sa Enter

% filter na kompenzaciu posunu v Hilbertovom FIR
d = zeros(1,length(h));  % dlzka Hilbertovho FIR filtra je neparna
d((length(h)+1)/2) = 1;     %

subplot(2,1,2);
plot(d);           % prikaz na zobrazenie
title('Impulzova odpoved filtra na kompenzaciu posunu');     % popis obrazku
xlabel('Diskretny cas');
ylabel('Amplituda');
grid;              % zapnutie mriezky v zobrazenom obrazku

pause;             % docasne zastavenie vypoctu, caka sa Enter

% generovanie a zobrazenie "uzitocneho" REALNEHO signalu
x = Asig*sin(2*pi*fsig*(0:N-1)/fvz);	% generovanie


figure(2);         % zobrazenie bude v samostatnom okne c.1
plot(x);           % prikaz na zobrazenie
title('Vstupny REALNY signal');     % popis obrazku
xlabel('Diskretny cas');
ylabel('Amplituda');
grid;              % zapnutie mriezky v zobrazenom obrazku

pause;             % docasne zastavenie vypoctu, caka sa Enter

y = filter(h,1,x);
x_delay = filter(d,1,x);

s = x_delay + j*y; % vytvorenie ANALYTICKEHO signalu

figure(3);         % zobrazenie bude v samostatnom okne c.1
plot(abs(s));      % prikaz na zobrazenie
title('Obalka ANALYTICKEHO signalu');     % popis obrazku
xlabel('Diskretny cas');
ylabel('Amplituda obalky');
grid;              % zapnutie mriezky v zobrazenom obrazku

pause;             % docasne zastavenie vypoctu, caka sa Enter


