/* 
implementacia kontrolneho suctu s "IBM CRC16" polynomom
s vyuzitim CRC tabulky

VSA, 2009-04-07, MD

*/ 


#define CODE_SIZE	(2048)               // zavisi od velkosti programu, hodnota bola zvolena
                                         // len pre demonstraciu                                       

/* definicia vlastnych typov na sprehladnenie programu */
typedef unsigned int      word;
typedef unsigned char     byte;

/* CRC16 tabulka na zryhlenie vypoctu CRC umiestnena v programovej pamati */
word code crc_table[256] =  {
        0x0000, 0xc0c1, 0xc181, 0x0140, 0xc301, 0x03c0, 0x0280, 0xc241,
        0xc601, 0x06c0, 0x0780, 0xc741, 0x0500, 0xc5c1, 0xc481, 0x0440,
        0xcc01, 0x0cc0, 0x0d80, 0xcd41, 0x0f00, 0xcfc1, 0xce81, 0x0e40,
        0x0a00, 0xcac1, 0xcb81, 0x0b40, 0xc901, 0x09c0, 0x0880, 0xc841,
        0xd801, 0x18c0, 0x1980, 0xd941, 0x1b00, 0xdbc1, 0xda81, 0x1a40,
        0x1e00, 0xdec1, 0xdf81, 0x1f40, 0xdd01, 0x1dc0, 0x1c80, 0xdc41,
        0x1400, 0xd4c1, 0xd581, 0x1540, 0xd701, 0x17c0, 0x1680, 0xd641,
        0xd201, 0x12c0, 0x1380, 0xd341, 0x1100, 0xd1c1, 0xd081, 0x1040,
        0xf001, 0x30c0, 0x3180, 0xf141, 0x3300, 0xf3c1, 0xf281, 0x3240,
        0x3600, 0xf6c1, 0xf781, 0x3740, 0xf501, 0x35c0, 0x3480, 0xf441,
        0x3c00, 0xfcc1, 0xfd81, 0x3d40, 0xff01, 0x3fc0, 0x3e80, 0xfe41,
        0xfa01, 0x3ac0, 0x3b80, 0xfb41, 0x3900, 0xf9c1, 0xf881, 0x3840,
        0x2800, 0xe8c1, 0xe981, 0x2940, 0xeb01, 0x2bc0, 0x2a80, 0xea41,
        0xee01, 0x2ec0, 0x2f80, 0xef41, 0x2d00, 0xedc1, 0xec81, 0x2c40,
        0xe401, 0x24c0, 0x2580, 0xe541, 0x2700, 0xe7c1, 0xe681, 0x2640,
        0x2200, 0xe2c1, 0xe381, 0x2340, 0xe101, 0x21c0, 0x2080, 0xe041,
        0xa001, 0x60c0, 0x6180, 0xa141, 0x6300, 0xa3c1, 0xa281, 0x6240,
        0x6600, 0xa6c1, 0xa781, 0x6740, 0xa501, 0x65c0, 0x6480, 0xa441,
        0x6c00, 0xacc1, 0xad81, 0x6d40, 0xaf01, 0x6fc0, 0x6e80, 0xae41,
        0xaa01, 0x6ac0, 0x6b80, 0xab41, 0x6900, 0xa9c1, 0xa881, 0x6840,
        0x7800, 0xb8c1, 0xb981, 0x7940, 0xbb01, 0x7bc0, 0x7a80, 0xba41,
        0xbe01, 0x7ec0, 0x7f80, 0xbf41, 0x7d00, 0xbdc1, 0xbc81, 0x7c40,
        0xb401, 0x74c0, 0x7580, 0xb541, 0x7700, 0xb7c1, 0xb681, 0x7640,
        0x7200, 0xb2c1, 0xb381, 0x7340, 0xb101, 0x71c0, 0x7080, 0xb041,
        0x5000, 0x90c1, 0x9181, 0x5140, 0x9301, 0x53c0, 0x5280, 0x9241,
        0x9601, 0x56c0, 0x5780, 0x9741, 0x5500, 0x95c1, 0x9481, 0x5440,
        0x9c01, 0x5cc0, 0x5d80, 0x9d41, 0x5f00, 0x9fc1, 0x9e81, 0x5e40,
        0x5a00, 0x9ac1, 0x9b81, 0x5b40, 0x9901, 0x59c0, 0x5880, 0x9841,
        0x8801, 0x48c0, 0x4980, 0x8941, 0x4b00, 0x8bc1, 0x8a81, 0x4a40,
        0x4e00, 0x8ec1, 0x8f81, 0x4f40, 0x8d01, 0x4dc0, 0x4c80, 0x8c41,
        0x4400, 0x84c1, 0x8581, 0x4540, 0x8701, 0x47c0, 0x4680, 0x8641,
        0x8201, 0x42c0, 0x4380, 0x8341, 0x4100, 0x81c1, 0x8081, 0x4040
};

/* tento kod spolu s tabulkou je ekvivalentny "IBM CRC16" C algorithmu:

typedef unsigned __int16  word;                // Visual C
typedef unsigned char     byte;

// "IBM" CRC-16, X^16 + X^15 + X^2 + 1
static word crc_gen(byte d, word c)
{
  word e;
  byte f;
  e = c^(word)d;
  for(f=0;f<8;f++)
  {
    if(e&1)
    {
        e >>= 1;
        e ^= 0xa001;
    }
    else e >>= 1;
  }
  return e;
}

*/


// funkcia realizuje zahrnutie 8-bitovej hodnoty "byte c" do celkoveho CRC suctu 
// v 16-bitovej premennej "word crc"
word update_crc( byte c, word crc ) {
    crc = (crc >> 8 ) ^ crc_table[(crc & 0xFF) ^ (byte) c];
    return crc;
}



word crc;	               // 16-bitova premenna vyuzita na vypocet CRC
byte code *ptr;            // smernik na byte objekt v CODE pamati, pre ktoru sa
                           // bude vytvarat CRC sucet
/*
Priklady specifickych smernikov do inych pamatovych priestorov 8051
char data *c;
//Pointer to character stored in Data memory

char xdata *c1;
//Pointer to character stored in External Data Memory.

char code *c2;
//Pointer to character stored in Code memory
 

*/

int k;                     // pocitadlo
char test;                 // testovacia premenna, moze sa vymazat

void main( void ) {

/*
Zakladny princip:
Nech kontrolovana kodova pamat ma rozsah od 0 do 2045 (posledne 
dva bajty na adresach 2046 a 2047 bude obsahovat CRC sucet od 
0-2045). Nech tento sucet je 0x1234.
Na adrese 2046 bude umiestneny LSB bajt CRC, teda 0x34, 
na adrese 2047 bude umiestneny MSB bajt CRC, teda 0x12

    ...                              // vypocet CRC pre bajty od 0-2045
	crc = 0x1234;                    // CRC hodnota pre prvky 0-2045  
    crc = update_crc( 0x34, crc );
    crc = update_crc( 0x12, crc );
	if (crc) {
	     ;                           // nenulova hodnota indikuje chybu CRC suctu
	}

*/

    crc = 0;               // vynulovanie premennej, ke sa bude vytvarat 16-bitova
	                       // CRC hodnota
    ptr = (byte*) 0x0000;  // zaciatok v kodovej pamati

	k = CODE_SIZE-2;       // crc hodnota prvych 2046 bajtov v CODE pamati

	while( k-- ) {
	    test = *ptr;       // len na kontrolu programu pocas cvicenia, moze sa vymazat
	    crc = update_crc( *ptr++, crc );
    }
// CRC je v tomto bode 0x4F66
    crc = update_crc( *ptr++, crc );   // ak na adrese 0x07FE bude ulozena hodnot 0x66
    crc = update_crc( *ptr++, crc );   // ak na adrese 0x07FF bude ulozena hodnot 0x4F
	                                   // (bude vysledne crc = 0)


	if (crc) {			   // zastavenie programu, kedze nesedi CRC sucet v pamati programu
		 while( 1 )         
		    ;              // (napr. moze sa realizovat reset programu watchdogom procesora)
	}
// tu moze byt vlozena uzitocna cinnost programu
	while( 1 )			   // zastavenie na konci programu
	   ;


}