/*
   Demonstracia, ze spravne pripojeny kontrolny sucet zabezpeci vysledne CRC rovne 0.
   Pozor, plati len pre CRC vypocty, ktore zacinaju z nulevej pociatocnej hodnoty!!!

   MD, 2017-03-13, PVS, KEMT FEI TUKE
*/

/**********************************************************************
 *
 * Filename:    main.c
 * 
 * Description: A simple test program for the CRC implementations.
 *
 * Notes:       To test a different CRC standard, modify crc.h.
 *
 * 
 * Copyright (c) 2000 by Michael Barr.  This software is placed into
 * the public domain and may be used for any purpose.  However, this
 * notice must not be changed or removed and no warranty is either
 * expressed or implied by its publication or distribution.
 **********************************************************************/

#include <stdio.h>
#include <string.h>

#include "crc.h"


void
main(void)
{
        unsigned char  test[] = "123456789";
/* MD
   CRC16  9 znakov 123456789 je 0xBB3D
   test2[] obsahuje povodne znaky "123456789" (bez kokcoveho znaku 0x00, t.j. 9 bajtov) + 2 bajty 
           kontrolneho suctu 0x3D, 0xBB, ktore su v uvedenom poradi pripojene na koiec znakov
           123456789 
*/
        unsigned char  test2[] = {'1', '2','3','4','5','6','7','8','9', 0x3D, 0xBB};


	/*
	 * Print the check value for the selected CRC algorithm.
	 */
	printf("The check value for the %s standard is 0x%X\n", CRC_NAME, CHECK_VALUE);
	
	/*
	 * Compute the CRC of the test message, slowly.
	 */
	printf("The crcSlow() of \"123456789\" is 0x%X\n", crcSlow(test, strlen(test)));
	
	/*
	 * Compute the CRC of the test message, more efficiently.
	 */
	crcInit();
	printf("The crcFast() of \"123456789\" is 0x%X\n", crcFast(test, strlen(test)));

/* MD
   demosntracia, ze CRC16 retazca znakov 123456789 (vlastnost je vseobecna, palti aj pre ine retazce)
   a prislusneho kontrolneho suctu (pre retazec 123456789 to je hodnota 0xB3D) je 0x0000
   (!!! kedze pociatocny zvysok pre CRC16 je 0x000. Pozor, toto neplati pre CRC vypocty, 
    ktore zacinaju z nenuloveho pociatocneho zvysku)
*/

	printf("The crcFast() of \"123456789\" + CRC16 is 0x%X\n", crcFast(test2, 11));


}   /* main() */