/*----------------------------------------------------------------------------
 * Name:    Blinky.c
 * Purpose: LED Flasher
 * Note(s): possible defines set in "options for target - C/C++ - Define"
 *            __USE_LCD   - enable Output on LCD
 *----------------------------------------------------------------------------
 * This file is part of the uVision/ARM development tools.
 * This software may only be used under the terms of a valid, current,
 * end user licence from KEIL for a compatible version of KEIL software
 * development tools. Nothing else gives you the right to use this software.
 *
 * This software is supplied "AS IS" without warranties of any kind.
 *
 * Copyright (c) 2008-2011 Keil - An ARM Company. All rights reserved.
 *----------------------------------------------------------------------------*/

#include <stdio.h>
#include "STM32F10x.h"
#include "Serial.h"
#include "LED.h"

#define DELAY 0xFFFFF

/*----------------------------------------------------------------------------
  Main Program
 *----------------------------------------------------------------------------*/
int main (void) {
  uint32_t i;

  LED_Init();                                /* LED Initialization            */
  SER_Init();                                /* UART Initialization           */

  printf("Welcome to BLINKY demo!\n");

	while(1){
	LED_Off(5);
	LED_On(6);
  for (i = 0; i < DELAY; i++);
	LED_On(5);
	LED_Off(6);
  for (i = 0; i < DELAY; i++);
  printf("BLINK! ");
	}
}
