#include <stdio.h>
#include <sys/types.h>          /* See NOTES */
#include <sys/socket.h>
#include <arpa/inet.h>
#include <strings.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>

#define MYPORT 3490

int main()
{
	int sock_desc = socket(AF_INET, SOCK_STREAM, 0);
	
	struct sockaddr_in my_addr;	
	//printf("%ld %ld\n", sizeof(struct sockaddr_in), sizeof(struct sockaddr));
	
	my_addr.sin_family = AF_INET; //naplnenie struktury sockaddr_in 
	my_addr.sin_port = htons(MYPORT);
	my_addr.sin_addr.s_addr = INADDR_ANY;
	bzero(&(my_addr.sin_zero), 8);
	if(bind(sock_desc, (struct sockaddr*)&my_addr, sizeof(my_addr))<0)
	{
		perror("bind failed");
		exit(-1);
	}
	if(listen(sock_desc, 5)<0)
	{
		perror("bind failed");
	}
	
	int cont = 1;
	while(cont)
	{
		struct sockaddr_in accept_addr;
		int len = sizeof(struct sockaddr_in);
		
		int accept_fd = accept(sock_desc, (struct sockaddr*)&accept_addr, &len);
		
		printf("%d %d %d\n", len, my_addr.sin_port, ntohs(my_addr.sin_port));
		//printf("%d %d %d\n", len, my_addr.sin_addr, ntohl(my_addr.sin_addr));
		
		char ip[100];
		inet_ntop(AF_INET, &my_addr.sin_addr, ip, 100);
		printf("ip: %s\n", ip);
		
		
		if(accept_fd < 0)
		{
			perror("accept failed");
		}
		char buff[100];
		read(accept_fd, buff, 100);
		printf("Client wrote: %s\n", buff);
		char *response = "I got the message!";
		write(accept_fd, response, strlen(response) + 1);
		if(strncmp("end", buff, 3) == 0)
		{
			cont = 0;
		}
		close(accept_fd);
	}
	close(sock_desc);
	exit(1);
}
