/************************************************************************
*
*  FREESCALE SEMICONDUCTORS INC.
*  ALL RIGHTS RESERVED
*  (c) Copyright 2003 Freescale semiconductors, Inc.
*
*************************************************************************
*
*  FILE NAME  : MOV_AVG_FLTR
*
*  PURPOSE    : MOV_AVG_FLTR macros definition for CW compiler
*
*  AUTHOR     :  Andriy Tymkiv, Anatoly Khaynakov
*
***********************************************************************/

#ifndef __MOV_AVG_FLTR_H
#define __MOV_AVG_FLTR_H


/************************************************************************
* NAME: MOV_AVG_FLTR
*
* DESCRIPTION: 	calculates the moving average filter of the src[0..size-1] 
*		array in dest[0..size-1] array with number of points `m'
*
* NOTE: 	The elements type is assumed to be FRAC32
*
*************************************************************************/

/*
	d0	xi
	d1	cntr
	d2	cntr
	d3	cntr = SIZE-M
	d4	xj
	d5	
	d6	
	d7	
	
	a0	dst
	a1	src
	a2	M
	a3	1/M
	a4	src
	a5	

*/


#define MOV_AVG_FLTR(dst,src,size,m) do {		\
		FRAC32 *b = dst;			\
		FRAC32 *a = src;			\
		long n = (size);			\
		long k = m;				\
		FRAC32 k1 = D_TO_F32(1.0 / (double) k);	\
	 	asm{					\
	 		/* Save registers */\
			lea -60(a7),a7			;\
			movem.l d0-d7/a0-a5,(a7)	;\
			/* Initialize MACSR register for fractional operations */\
			move.l #0x20,d0			;\
			move.l d0,MACSR			;\
			/* Load function variables */\
			move.l b,a0			;\
			move.l a,a1			;\
			move.l a1,a4			;\
			move.l k,d2			;\
			move.l k1,a3			;\
			move.l n,d1			;\
			/* Load counters */  \
			sub.l #1,d2			;\
			sub.l d2,d1			;\
			move.l d2,d3			;\
			/* Initialize eMAC accumulators */ \
			move.l #0,ACC0			;\
			/* Fill ring buffer */  \
			move.l (a1)+,d4			;\
			mac.l d4,a3,ACC0		;\
			subq.l #1,d3			;\
			bne *-8			;\
			/* Calculate average */  \
			move.l #0,d0			;\
			move.l (a1)+,d4			;\
			mac.l d4,a3,ACC0		;\
			msac.l d0,a3,ACC0		;\
			move.l (a4)+,d0			;\
			move.l ACC0,d5			;\
			move.l d5,(a0)+			;\
			subq.l #1,d1			;\
			bne *-18			;\
			/* Writeback average */  \
			move.l (a4)+,d4			;\
			move.l d4,(a0)+			;\
			sub.l #1,d2			;\
			bne *-6				;\
			/* Restore registers */  \
			movem.l (a7),d0-d7/a0-a5	;\
			lea 60(a7),a7	    		;\
			};				\
		} while (0)


#endif // __MOV_AVG_FLTR_H