/************************************************************************
*
*  FREESCALE SEMICONDUCTORS INC.
*  ALL RIGHTS RESERVED
*  (c) Copyright 2003 Freescale semiconductors, Inc.
*
*************************************************************************
*
*  FILE NAME  : matr_mul.h
*
*  PURPOSE    : MATR_MUL_{S,U}L macros definition for CW compiler
*
*  AUTHOR     : Igor Drozdinsky, Dmitry Karpenko
*
***********************************************************************/

#ifndef __MATR_MUL_H
#define __MATR_MUL_H


/************************************************************************
* NAME: MATR_MUL_SL
*
* DESCRIPTION: 	multiplies 2d array arr1[m][n] by arr2[n][p]. Stores result
*		into arrr[m][p]
*
* NOTE: 	The elements type is assumed to be signed long
*************************************************************************/

#define MATR_MUL_SL(arrr, arr1, arr2, m, n, p) ({		\
			long *ma = (&arr1[0][0]);		\
			long *mb = (&arr2[0][0]);		\
			long *mc = (&arrr[0][0]);		\
			int szn = (n);				\
			int szm = (m);				\
			int szp = (p);				\
			asm{					\
			/* Save registers */\
			lea	-60(a7), a7			;\
			movem.l	d0-d7/a0-a5, (a7)		;\
			move.l	MACSR, d0			;\
			move.l	d0, 56(a7)			;\
			/* Initialize MACSR register for signed operations */\
			move.l	%0x00, d0			;\
			move.l	d0, MACSR			;\
			/* Load function variables */\
			move.l	ma, a0				;\
			move.l	mb, a2				;\
			move.l	mc, a5				;\
			move.l	%0, ACC0			;\
								;\
			move.l	szp, d3				;\
			lsl.l	%2, d3				;\
			move.l	szm, d0				;\
			move.l	szp, d1				;\
			/* Locate pointers */\
			lea	(a0), a1			;\
			lea	(a2), a3			;\
			lea	4(a2), a2			;\
			move.l	szn, d2				;\
			/* Calculate the value in the current cell */\
 			move.l	(a3), d4			;\
			add.l	d3, a3				;\
			move.l	(a1)+, a4 			;\
			mac.l	d4, a4, ACC0			;\
			subq.l	%1, d2				;\
			bne	*-12				;\
			/* Store the value */\
			move.l	ACC0, d4			;\
			move.l	%0, ACC0			;\
			move.l	d4, (a5)+			;\
			/* Next column */\
			subq.l	%1, d1				;\
			bne	*-38				;\
			/* Initialize counters and go to next row */\
			move.l	szn, d4				;\
			lsl.l	%2, d4				;\
			add.l	d4, a0				;\
			move.l	mb, a2				;\
			subq.l	%1, d0				;\
			bne	*-58				;\
			/* Restore registers */  \
			move.l	56(a7),d0			;\
			move.l	d0, MACSR			;\
			movem.l	(a7), d0-d7/a0-a5		;\
			lea	60(a7), a7			;\
			};					\
			arrr;})
				
/************************************************************************
* NAME: MATR_MUL_UL
*
* DESCRIPTION: 	multiplies 2d array arr1[m][n] by arr2[n][p]. Stores result
*		into arrr[m][p]
*
* NOTE: 	The elements type is assumed to be unsigned long
*************************************************************************/

#define MATR_MUL_UL(arrr, arr1, arr2, m, n, p) ({		\
			unsigned long *ma = (&arr1[0][0]);		\
			unsigned long *mb = (&arr2[0][0]);		\
			unsigned long *mc = (&arrr[0][0]);		\
			int szn = (n);				\
			int szm = (m);				\
			int szp = (p);				\
			asm{					\
			/* Save registers */\
			lea	-60(a7), a7			;\
			movem.l	d0-d7/a0-a5, (a7)		;\
			move.l	MACSR, d0			;\
			move.l	d0, 56(a7)			;\
			/* Initialize MACSR register for unsigned operations */\
			move.l	%0x40, d0			;\
			move.l	d0, MACSR			;\
			/* Load function variables */\
			move.l	ma, a0				;\
			move.l	mb, a2				;\
			move.l	mc, a5				;\
			move.l	%0, ACC0			;\
								;\
			move.l	szp, d3				;\
			lsl.l	%2, d3				;\
			move.l	szm, d0				;\
			move.l	szp, d1				;\
			/* Locate pointers */\
			lea	(a0), a1			;\
			lea	(a2), a3			;\
			lea	4(a2), a2			;\
			move.l	szn, d2				;\
			/* Calculate the value in the current cell */\
			move.l	(a3), d4			;\
			add.l	d3, a3				;\
			move.l	(a1)+, a4 			;\
								;\
			mac.l	d4, a4, ACC0			;\
			subq.l	%1, d2				;\
			bne	*-12				;\
			/* Store the value */\
			move.l	ACC0, d4			;\
			move.l	%0, ACC0			;\
			move.l	d4, (a5)+			;\
			/* Next column */\
			subq.l	%1, d1				;\
			bne	*-38				;\
			/* Initialize counters and go to next row */\
			move.l	szn, d4				;\
			lsl.l	%2, d4				;\
			add.l	d4, a0				;\
			move.l	mb, a2				;\
			subq.l	%1, d0				;\
			bne	*-58				;\
			/* Restore registers */  \
			move.l	56(a7),d0			;\
			move.l	d0, MACSR			;\
			movem.l	(a7), d0-d7/a0-a5		;\
			lea	60(a7), a7			;\
			};					\
			arrr;})
				
#endif //__MATR_MUL_H
