/************************************************************************
*
*  FREESCALE SEMICONDUCTORS INC.
*  ALL RIGHTS RESERVED
*  (c) Copyright 2003 Freescale semiconductors, Inc.
*
*************************************************************************
*
*  FILE NAME  : LPASS_4STG_FLTR
*
*  PURPOSE    : LPASS_4STG_FLTR macros definition for CW compiler
*
*  AUTHOR     :  Andriy Tymkiv, Anatoly Khaynakov
*
***********************************************************************/

#ifndef __LPASS_4STG_FLTR_H
#define __LPASS_4STG_FLTR_H


/************************************************************************
* NAME: LPASS_4STG_FLTR
*
* DESCRIPTION: 	calculates the four stage low-pass filter of the 
*		src[0..size-1] array in dest[0..size-1] array with filter's
*		response that controlled by parameter `x'
*
* NOTE: 	The elements type is assumed to be FRAC32
*
*************************************************************************/

/*
	d0	y
	d1	cntr
	d2	cntr
	d3	y
	d4	y
	d5	y
	d6	coef b1
	d7	coef b2
	
	a0	dst
	a1	src
	a2	x
	a3	coef a0
	a4	coef a1 || b3
	a5	coef a2	|| b4
*/


#define LPASS_4STG_FLTR(dst,src,size,x) do {		\
		FRAC32 *b = dst;			\
		FRAC32 *a = src;			\
		long n = (size);			\
		double k = F32_TO_D(x);			\
		double d_a0, d_b1, d_b2, d_b3, d_b4;	\
		d_a0 = 1.0 - k;				\
		d_b1 = 4.0 * k;				\
		d_b2 = 6.0 * k * k;			\
		d_b3 = d_b1 * k * k;			\
		d_b4 = k * k * k * k;			\
		d_a0 *= d_a0;				\
		d_a0 *= d_a0;				\
		__IMPL_LPASS_4STG_FLTR(b, a, n,		\
			D_TO_F32(d_a0),			\
			D_TO_F32(d_b1),			\
			D_TO_F32(d_b2),			\
			D_TO_F32(d_b3),			\
			D_TO_F32(d_b4));		\
		} while (0)



#define __IMPL_LPASS_4STG_FLTR(dst,src,size,c_a0,c_b1,c_b2,c_b3,c_b4) do {		\
		FRAC32 *bb = dst;			\
		FRAC32 *aa = src;			\
		long nn = (size);			\
		FRAC32 coef_a0 = (c_a0);		\
		FRAC32 coef_b1 = (c_b1);		\
		FRAC32 coef_b2 = (c_b2);		\
		FRAC32 coef_b3 = (c_b3);		\
		FRAC32 coef_b4 = (c_b4);		\
	 	asm{					\
	 	  /* Save registers */\
			lea -60(a7),a7			;\
			movem.l d0-d7/a0-a5,(a7)	;\
			/* Initialize MACSR register for signed operations */\
			move.l #0x00,d0			;\
			move.l d0,MACSR			;\
			/* Load function variables */\
			move.l bb,a0			;\
			move.l aa,a1			;\
			move.l coef_a0,a3		;\
			move.l coef_b1,d6		;\
			move.l coef_b2,d7		;\
			move.l coef_b3,a4		;\
			move.l coef_b4,a5		;\
			/* Clean registers and accumulator */  \
			moveq.l %0,d0			;\
			moveq.l %0,d3			;\
			moveq.l %0,d4			;\
			moveq.l %0,d5			;\
			move.l #0,ACC0			;\
			/* Load counter */  \
			move.l nn,d1			;\
			move.l d1,d2			;\
			/* Load in d1 number of 4 operations */ \
			asr.l %2,d1			;\
			beq *+130			;\
			/* Perform the filter 4 by 4 operations */ \
			move.l (a1)+,a2			;\
			mac.w a3.u,a2.u,<<,ACC0		;\
			macl.w d6.u,d0.u,<<,(a1)+,a2,ACC0	;\
			msac.w d7.u,d3.u,<<,ACC0		;\
			mac.w a4.u,d4.u,<<,ACC0		;\
			msac.w a5.u,d5.u,<<,ACC0		;\
			/* Store results and clear accumulators */ \
			move.l ACC0,d5			;\
			move.l #0,ACC0			;\
			move.l d5,(a0)+			;\
			mac.w a3.u,a2.u,<<,ACC0		;\
			macl.w d6.u,d5.u,<<,(a1)+,a2,ACC0	;\
			msac.w d7.u,d0.u,<<,ACC0		;\
			mac.w a4.u,d3.u,<<,ACC0		;\
			msac.w a5.u,d4.u,<<,ACC0		;\
			move.l ACC0,d4			;\
			move.l #0,ACC0			;\
			move.l d4,(a0)+			;\
			mac.w a3.u,a2.u,<<,ACC0		;\
			macl.w d6.u,d4.u,<<,(a1)+,a2,ACC0	;\
			msac.w d7.u,d5.u,<<,ACC0		;\
			mac.w a4.u,d0.u,<<,ACC0		;\
			msac.w a5.u,d3.u,<<,ACC0		;\
			move.l ACC0,d3			;\
			move.l #0,ACC0			;\
			move.l d3,(a0)+			;\
			mac.w a3.u,a2.u,<<,ACC0		;\
			macl.w d6.u,d3.u,<<,(a1)+,a2,ACC0	;\
			msac.w d7.u,d4.u,<<,ACC0		;\
			mac.w a4.u,d5.u,<<,ACC0		;\
			msac.w a5.u,d0.u,<<,ACC0		;\
			move.l ACC0,d0			;\
			move.l #0,ACC0			;\
			move.l d0,(a0)+			;\
			subq.l %1,d1			;\
			bne *-122			;\
			/* Load in d2 number of operations left */\
			and.l %3,d2			;\
			beq *+42			;\
			/* Perform last operations */\
			mac.w a3.u,a2.u,<<,ACC0		;\
			macl.w d6.u,d0.u,<<,(a1)+,a2,ACC0	;\
			msac.w d7.u,d3.u,<<,ACC0		;\
			mac.w a4.u,d4.u,<<,ACC0		;\
			msac.w a5.u,d5.u,<<,ACC0		;\
			move.l d4,d5			;\
			move.l d3,d4			;\
			move.l d0,d3			;\
			/* Store result and clear accumulator */ \
			move.l ACC0,d0			;\
			move.l #0,ACC0			;\
			move.l d0,(a0)+			;\
			subq.l %1,d2			;\
			bne *-38			;\
			/* Restore registers */  \
			movem.l (a7),d0-d7/a0-a5	;\
			lea 60(a7),a7	    		;\
			};				\
		} while (0)


#endif // __LPASS_4STG_FLTR_H
