/************************************************************************
*
*  FREESCALE SEMICONDUCTORS INC.
*  ALL RIGHTS RESERVED
*  (c) Copyright 2003 Freescale semiconductors, Inc.
*
*************************************************************************
*
*  FILE NAME  : LPASS_1POLE_FLTR
*
*  PURPOSE    : LPASS_1POLE_FLTR macros definition for CW compiler
*
*  AUTHOR     :  Andriy Tymkiv, Anatoly Khaynakov
*
***********************************************************************/

#ifndef __LPASS_1POLE_FLTR_H
#define __LPASS_1POLE_FLTR_H


/************************************************************************
* NAME: LPASS_1POLE_FLTR
*
* DESCRIPTION: 	calculates the single pole low-pass filter of the 
*		src[0..size-1] array in dest[0..size-1] array with filter's
*		response that controlled by parameter `x'
*
* NOTE: 	The elements type is assumed to be FRAC32
*
*************************************************************************/

/*
	d0	y[i-1]
	d1	cntr
	d2	cntr
	d3	x[i]
	d4	x[i+1]
	d5	x[i+2]
	d6	coef b1
	d7	coef b2
	
	a0	dst
	a1	src
	a2	x[i+3]
	a3	coef a0
	a4	coef a1 || b3
	a5	coef a2	|| b4




*/


#define LPASS_1POLE_FLTR(dst,src,size,x) do {		\
		FRAC32 *b = dst;			\
		FRAC32 *a = src;			\
		long n = (size);			\
		long k = x;				\
	 	asm{					\
	 	  /* Save registers */\
			lea -60(a7),a7			;\
			movem.l d0-d7/a0-a5,(a7)	;\
			/* Initialize MACSR register for signed operations */\
			move.l #0x00,d0			;\
			move.l d0,MACSR			;\
			/* Load function variables */\
			move.l b,a0			;\
			move.l a,a1			;\
			move.l k,d6			;\
			move.l #0x7FFFFFFF,a3		;\
			sub.l d6,a3			;\
			/* Clean register and accumulator */  \
			move.l #0,d0			;\
			move.l #0,ACC0			;\
			/* Load counter */  \
			move.l n,d1			;\
			move.l d1,d2			;\
			/* Load in d1 number of 4 operations */ \
			asr.l %2,d1			;\
			beq *+88			;\
			/* Perform the filter 4 by 4 operations */ \
			movem.l (a1),d3-d5/a2		;\
			add.l #16,a1			;\
			mac.w a3.u,d3.u,<<,ACC0		;\
			mac.w d6.u,d0.u,<<,ACC0		;\
			/* Store results and clear accumulators */ \
			move.l ACC0,d0			;\
			move.l #0,ACC0			;\
			move.l d0,(a0)+			;\
			mac.w a3.u,d4.u,<<,ACC0		;\
			mac.w d6.u,d0.u,<<,ACC0		;\
			move.l ACC0,d0			;\
			move.l #0,ACC0			;\
			move.l d0,(a0)+			;\
			mac.w a3.u,d5.u,<<,ACC0		;\
			mac.w d6.u,d0.u,<<,ACC0		;\
			move.l ACC0,d0			;\
			move.l #0,ACC0			;\
			move.l d0,(a0)+			;\
			mac.w a3.u,a2.u,<<,ACC0		;\
			mac.w d6.u,d0.u,<<,ACC0		;\
			move.l ACC0,d0			;\
			move.l #0,ACC0			;\
			move.l d0,(a0)+			;\
			subq.l %1,d1			;\
			bne *-84			;\
			/* Load in d2 number of operations left */\
			and.l %3,d2			;\
			beq *+26			;\
			/* Perform last operations */\
			move.l (a1)+,d3			;\
			mac.w a3.u,d3.u,<<,ACC0		;\
			mac.w d6.u,d0.u,<<,ACC0		;\
			/* Store result and clear accumulator */ \
			move.l ACC0,d0			;\
			move.l #0,ACC0			;\
			move.l d0,(a0)+			;\
			subq.l %1,d2			;\
			bne *-22			;\
			/* Restore registers */  \
			movem.l (a7),d0-d7/a0-a5	;\
			lea 60(a7),a7	    		;\
			};				\
		} while (0)


#endif // __LPASS_1POLE_FLTR_H
