/************************************************************************
*
*  FREESCALE SEMICONDUCTORS INC.
*  ALL RIGHTS RESERVED
*  (c) Copyright 2004 Freescale semiconductors, Inc.
*
*************************************************************************
*
*  FILE NAME  : CONV.h
*
*  PURPOSE    : CONV macro definition for CW compiler
*
*  AUTHOR     : Igor Drozdinsky, Dmitry Karpenko
*
***********************************************************************/

#ifndef __CONV_H
#define __CONV_H



/************************************************************************
* NAME: CONV
*
* DESCRIPTION: 	returns the convolve of arrays arr1 and arr2
*
* NOTE: 	The elements type is assumed to be unsigned long
*************************************************************************/

#define CONV(y, x, h, xsize, hsize) ({			\
				FRAC32 *xci = (x);		\
				FRAC32 *hci = (h);		\
				FRAC32 *yci = (y);		\
				int sxci = (xsize);		\
				int shci = (hsize);		\
				asm{				\
				/* Save registers */\
				lea	-60(a7), a7		;\
				movem.l	d0-d7/a0-a5, (a7)		;\
				/* Load function variables */\
				move.l	hci, a0				;\
				move.l	xci, a2				;\
				move.l	yci, a4				;\
				move.l	shci, d0			;\
				move.l	%0, ACC0			;\
				/* Locate pointers */\
				move.l	d0, d1				;\
				subq.l	%1, d1				;\
				clr.l	d6				;\
				/* Perform the convolution */\
				addq.l	%4, d6				;\
				move.l	d6, d2				;\
				movea.l	a0, a1				;\
				movea.l	a2, a3				;\
				add.l	d2, a3				;\
				/* Multiply the signals */\
				move.l	(a1)+, d4			;\
				move.l	-(a3), d5			;\
				mac.w	d4.u, d5.u, <<, acc0		;\
				subq.l	%4, d2				;\
				bne	*-10				;\
				/* Store the result */\
				move.l	acc0, d7				;\
				move.l	%0, acc0				;\
				move.l	d7, (a4)+			;\
				subq.l	%1, d1				;\
				bne	*-34				;\
									;\
				movea.l	a0, a1				;\
				move.l	d0, d2				;\
				lsl.l	%2, d2				;\
				add.l	d2, a1				;\
				movea.l	a2, a3				;\
									;\
				move.l	sxci, d1			;\
				sub.l	d0, d1				;\
				addq.l	%1, d1				;\
				beq	*+38				;\
									;\
				movea.l	a1, a0				;\
				movea.l	a3, a5				;\
				move.l	d0, d5				;\
				/* Multiply the signals */\
				move.l	-(a0), d3			;\
				move.l	(a5)+, d4			;\
				mac.w	d3.u, d4.u, <<, acc0 		;\
				subq.l	%1, d5				;\
				bne	*-10				;\
				/* Store the result */\
				move.l	acc0, d5				;\
				move.l	%0, acc0				;\
				move.l	d5, (a4)+			;\
				lea	4(a3), a3			;\
				subq.l	%1, d1				;\
				bne	*-34				;\
									;\
				move.l	hci, a0				;\
				move.l	d0, d1				;\
				subq.l	%1, d1				;\
				clr.l	d6				;\
				lsl.l	%2, d0				;\
				add.l	d0, a0				;\
				move.l	sxci, d0			;\
				lsl.l	%2, d0				;\
				add.l	d0, a2				;\
				lsl.l	%2, d1				;\
				add.l	d1, a4				;\
									;\
				addq.l	%4, d6				;\
				move.l	d6, d2				;\
				movea.l	a0, a1				;\
				movea.l	a2, a3				;\
				sub.l	d2, a3				;\
				/* Multiply the signals */\
				move.l	-(a1), d4			;\
				move.l	(a3)+, d5			;\
				mac.w	d4.u, d5.u, <<, acc0		;\
				subq.l	%4, d2				;\
				bne	*-10				;\
				/* Store the result */\
				move.l	acc0, d7				;\
				move.l	%0, acc0				;\
				move.l	d7, -(a4)			;\
				subq.l	%4, d1				;\
				bne	*-34				;\
				/* Restore registers */  \
				movem.l	(a7), d0-d7/a0-a5		;\
				lea	60(a7), a7			;\
				};					\
				y;})
				
#endif //__CONV_H
