/************************************************************************
*
*  FREESCALE SEMICONDUCTORS INC.
*  ALL RIGHTS RESERVED
*  (c) Copyright 2003 Freescale semiconductors, Inc.
*
*************************************************************************
*
*  FILE NAME  : macro.h
*
*  PURPOSE    : collects all macros definitions for CW compiler
*
*  AUTHOR     : Andriy Tymkiv, Anatoly Khaynakov, Igor Drozdinsky, Dmitry Karpenko
*
***********************************************************************/

#ifndef __MACRO_H
#define __MACRO_H

#pragma gcc_extensions on
#pragma longlong on

typedef long FRAC32;
typedef long long FIXED64;

#define D_TO_F32(X) ((long)((X)*2147483648.0))
#define F32_TO_D(X) (((double)(X)) / 2147483648.0d)

#define D_TO_F64(X) ((long long)((X)*4294967296.0))
#define F64_TO_D(X) (((double)(X))/4294967296.0)

#define PI (3.1415926535)

#define  F64_2PI    D_TO_F64(3.1415926535 * 2.0)
#define  F64_PI	    D_TO_F64(3.1415926535)
#define  F64_PI2    D_TO_F64(3.1415926535 / 2.0)
#define  F64_PI4    D_TO_F64(3.1415926535 / 4.0)
#define  F64_3PI2   D_TO_F64(3.1415926535 * 3.0 / 2.0)

#include "common\arr1d_sum.h"
#include "common\arr1d_add.h"
#include "common\arr1d_addsc.h"

#include "common\arr2d_sum.h"
#include "common\arr2d_add.h"
#include "common\arr2d_addsc.h"

#include "common\arr1d_prod.h"
#include "common\arr2d_prod.h"

#include "common\arr2d_maxmin.h"
#include "common\arr1d_maxmin.h"

#include "common\arr1d_cast.h"
#include "common\arr2d_cast.h"


#include "common\runn_sum.h"
#include "common\first_diff.h"


#include "emac\arr1d_mul.h"
#include "emac\arr1d_mulsc.h"

#include "emac\arr2d_mul.h"
#include "emac\arr2d_mulsc.h"

#include "emac\dot_prod.h"
#include "emac\rdot_prod.h"

#include "emac\sin_cos.h"

#include "emac\mov_avg_fltr.h"

#include "emac\lpass_1pole_fltr.h"
#include "emac\hpass_1pole_fltr.h"
#include "emac\lpass_4stg_fltr.h"
#include "emac\band_fltr.h"

#include "emac\conv.h"
#include "emac\matr_mul.h"
#include "emac\mul.h"


#endif //__MACRO_H
