/************************************************************************
*
*  FREESCALE SEMICONDUCTORS INC.
*  ALL RIGHTS RESERVED
*  (c) Copyright 2003 Freescale semiconductors, Inc.
*
*************************************************************************
*
*  FILE NAME  : sin.h
*
*  PURPOSE    : SIN, COS, SIN_F, COS_F macros definition for CW compiler
*
*  AUTHOR     : Igor Drozdinsky, Dmitry Karpenko
*
***********************************************************************/

#ifndef __SIN_H
#define __SIN_H

/************************************************************************
* NAME	      : SIN_F
*
* DESCRIPTION : Sin computing for FRAC32 value	
*
* NOTES       : The type of result is assumed to be unsigned long
*		The ang value is asumed to be 0..PI/4.		
*************************************************************************/

#define SIN_F(ang)	({					\
				FRAC32 angsin = (ang);		\
				unsigned long res = 0;   	\
				asm{				\
				/* Save registers */\
				lea	-60(a7), a7		;\
				movem.l	d0-d6/a0-a5, (a7)	;\
				move.l	MACSR, d6		;\
				/* Initialize MACSR register for fractional mode */\
				move.l	%0x20, d0		;\
				move.l	d0, MACSR		;\
				/* Load angle */\
				move.l 	angsin, d0		;\
				/* Perform the sine operation using approximations */  \
				move.l	%0, ACC0		;\
				mac.l	d0, d0, ACC0		;\
				movclr.l	ACC0, d1	;\
				mac.l	d1, d0, ACC0		;\
				movclr.l	ACC0, d2	;\
				mac.l	d1, d2, ACC0		;\
				movclr.l	ACC0, d3	;\
				mac.l	d1, d3, ACC0		;\
				movclr.l	ACC0, d4	;\
				mac.l	d1, d4, ACC0		;\
				movclr.l	ACC0, d5	;\
				mac.l	d1, d5, ACC0		;\
				movclr.l	ACC0, d6	;\
				move.l	d0, ACC0		;\
				/* Load standard factor values */\
				movea.l	%357913941, a0		;\
				movea.l	%17895697, a1		;\
				movea.l	%426088, a2		;\
				movea.l	%5917, a3		;\
				movea.l	%53, a4			;\
				/* Perform approximation by Taylor Series */\
				msac.l	d2, a0, ACC0		;\
				mac.l	d3, a1, ACC0		;\
				msac.l	d4, a2, ACC0		;\
				mac.l	d5, a3, ACC0		;\
				msac.l	d6, a4, ACC0		;\
				move.l	ACC0, d0		;\
				/* Store result */  \
				move.l	d0, res			;\
				/* Restore registers */  \
				move.l	d6, MACSR		;\
				movem.l	(a7), d0-d6/a0-a5	;\
				lea	60(a7), a7		;\
				};				\
				res; })

/************************************************************************
* NAME        : COS_F
*
* DESCRIPTION : Cos computing for FRAC32 value
*
* NOTES       : The type of result is assumed to be unsigned long
*		The ang value is assumed to be 0..PI/4
*************************************************************************/

#define COS_F(ang)	({					\
				FRAC32 angcos = (ang);		\
				unsigned long res = 0;		\
				asm{				\
				/* Save registers */\
				lea	-60(a7), a7		;\
				movem.l	d0-d6/a0-a5, (a7)	;\
				move.l	MACSR, d6		;\
				/* Initialize MACSR register for fractional mode */\
				move.l	%0x20, d0		;\
				move.l	d0, MACSR		;\
				/* Load angle */\
				move.l 	angcos, d0		;\
				/* Perform the cosine operation using approximations */  \
				move.l	%0, ACC0		;\
				move.l	%0, ACC1		;\
				mac.l	d0, d0, ACC0		;\
				movclr.l	ACC0, d1	;\
				mac.l	d1, d1, ACC0		;\
				movclr.l	ACC0, d2	;\
				mac.l	d1, d2, ACC0		;\
				mac.l	d2, d2, ACC1		;\
				movclr.l	ACC0, d3	;\
				movclr.l	ACC1, d4	;\
				mac.l	d2, d3, ACC0		;\
				mac.l	d3, d3, ACC1		;\
				movclr.l	ACC0, d5	;\
				movclr.l	ACC1, d6	;\
				/* Load standard factor values */\
				move.l	%0x7fffffff, ACC0	;\
				movea.l	%1073741824, a0		;\
				movea.l	%89478485, a1		;\
				movea.l	%2982616, a2		;\
				movea.l	%53261, a3		;\
				movea.l	%591, a4		;\
				movea.l	%4, a5			;\
				/* Perform approximation by Taylor Series */\
				msac.l	d1, a0, ACC0		;\
				mac.l	d2, a1, ACC0		;\
				msac.l	d3, a2, ACC0		;\
				mac.l	d4, a3, ACC0		;\
				msac.l	d5, a4, ACC0		;\
				mac.l	d6, a5, ACC0		;\
				move.l	ACC0, d0		;\
				/* Store result */  \
				move.l	d0, res			;\
				move.l	d6, MACSR		;\
				/* Restore registers */  \
				movem.l	(a7), d0-d6/a0-a5	;\
				lea	60(a7), a7		;\
				};				\
				res; })				

/************************************************************************
* NAME	      : SIN
*
* DESCRIPTION : Sin computing for FIXED64 value
*
* NOTES	      :	The type of result is assumed to be FIXED64
*		The value of asing is assumed to be 0..2*PI
*************************************************************************/

#define SIN(ang)	({					\
				FIXED64 asing = (ang);		\
				FIXED64 res;			\
				int sign = 0, func = 0;		\
				if(asing>F64_PI)		\
				{				\
					asing -= F64_PI;	\
					sign = 1;		\
				}				\
				if(asing>F64_PI2)		\
				{				\
					asing = F64_PI - asing; \
				}				\
				if(asing>F64_PI4)		\
				{				\
					asing = F64_PI2 - asing;\
					func = 1;		\
				}				\
				if(func)			\
				{				\
					res = COS_F(asing >> 1) << 1;\
				}				\
				else				\
				{				\
					res = SIN_F(asing >> 1) << 1;\
				}				\
				if(sign)			\
					res = -res;		\
				res;				\
			})

/************************************************************************
* NAME	      : COS
*
* DESCRIPTION :	Cos computing for FIXED64 value 	
*
* NOTES       :	The type of result is assumed to be FIXED64
*		The value of acosg is assumed to be 0..2*PI
*************************************************************************/

#define COS(ang)	({					\
				FIXED64 acosg = (ang);		\
				FIXED64 res;			\
				int csign = 0, func = 0;	\
				if(acosg>F64_PI)		\
				{				\
					acosg = F64_2PI - acosg;\
				}				\
				if(acosg>F64_PI2)		\
				{				\
					acosg = F64_PI - acosg;	\
					csign = 1;		\
				}				\
				if(acosg>F64_PI4)		\
				{				\
					acosg = F64_PI2 - acosg;\
					func = 1;		\
				}				\
				if(func)			\
				{				\
					res = SIN_F(acosg >> 1) << 1;\
				}				\
				else				\
				{				\
					res = COS_F(acosg >> 1) << 1;\
				}				\
				if(csign)			\
					res = -res;		\
				res;				\
			})

#endif //__SIN_H
