/************************************************************************
*
*  FREESCALE SEMICONDUCTORS INC.
*  ALL RIGHTS RESERVED
*  (c) Copyright 2003 Freescale semiconductors, Inc.
*
*************************************************************************
*
*  FILE NAME  : mul.h
*
*  PURPOSE    : MUL macro definition for CW compiler
*
*  AUTHOR     : Igor Drozdinsky, Dmitry Karpenko
*
***********************************************************************/

#ifndef __MUL_H
#define __MUL_H



/************************************************************************
* NAME: MUL
*
* DESCRIPTION: 	returns a product of `m1' and `m2' values
*
* NOTE: 	The elements type is assumed to be FIXED64
*
*************************************************************************/


#define MUL(m1, m2) ({				\
	FIXED64 mul1 = (m1);			\
	FIXED64 mul2 = (m2);			\
	FIXED64 res = 0;			\
	asm{					;\
		/* Save registers */\
		lea	-60(a7), a7		;\
		movem.l	d0-d6/a0-a5, (a7)	;\
		move.l	MACSR, d6		;\
		/* Load function variables */\
		lea	mul1, a0		;\
		lea	mul2, a1		;\
		/* Set eMAC to fractional mode */\
		move.l	%0x20, d5		;\
		move.l	d5, MACSR		;\
		clr.l	d4			;\
		/* Save in d0/d1 first operand and in d2/d3 second operand */  \
		movem.l	(a0), d0/d1		;\
		movem.l	(a1), d2/d3		;\
		clr.l	d5			;\
		/* Verify the sign of the first operand */  \
		tst.l	d0			;\
		bpl	*+12			;\
		not.l	d0			;\
		not.l	d1			;\
		addq.l	%1, d1			;\
		addx.l	d5, d0			;\
		/* Hold the sign in d4 */  \
		moveq.l	%1, d4			;\
		/* Verify the sign of the second operand */  \
		tst.l	d2			;\
		bpl	*+16			;\
		not.l	d2			;\
		not.l	d3			;\
		addq.l	%1, d3			;\
		addx.l	d5, d2			;\
		/* Hold the sign in d4 after second operand */  \
		eori.l	%1, d4			;\
		/* Initialize eMAC accumulators */  \
		move.l	%0, ACC0		;\
		move.l	%0, ACC1		;\
		move.l	%0, ACC2		;\
		move.l	%0, ACC3		;\
		/* Perform MUL operation with 64 bits */  \
		lsr.l	%1, d1			;\
		lsr.l	%1, d3			;\
						;\
		mac.l	d1, d3, ACC0		;\
		mac.l	d0, d3, ACC1		;\
		move.l	%0, ACCEXT01		;\
		mac.l	d1, d2, ACC1		;\
						;\
		lsl.l	%1, d1			;\
		lsl.l	%1, d3			;\
						;\
		move.l	%0x40, d5		;\
		move.l	d5, MACSR		;\
						;\
		mac.l	d0, d3, ACC2		;\
		mac.l	d1, d2, ACC3		;\
		mac.l	d0, d2, ACC1		;\
						;\
		move.l	ACC1, d0		;\
		move.l	ACC0, d1		;\
						;\
		move.l	ACC2, d2		;\
		move.l	ACC3, d3		;\
						;\
		clr.l	d5			;\
		lsl.l	%1, d1			;\
		addx.l	d5, d0			;\
		add.l	d2, d1			;\
		addx.l	d5, d0			;\
		add.l	d3, d1			;\
		addx.l	d5, d0			;\
						;\
		tst.l	d4			;\
		beq	*+10			;\
		/* Invert the sign of the result in case of negative result */  \
		not.l	d0			;\
		not.l	d1			;\
		addq.l	%1, d1			;\
		addx.l	d5, d0			;\
		/* Store the result */ \
		lea	res, a0			;\
		movem.l	d0/d1, (a0)		;\
		/* Restore registers */  \
		move.l	d6, MACSR		;\
		movem.l	(a7), d0-d6/a0-a5	;\
		lea	60(a7), a7		;\
	};					\
	res;})

#endif //__MUL_H
