/************************************************************************
*
*  FREESCALE SEMICONDUCTORS INC.
*  ALL RIGHTS RESERVED
*  (c) Copyright 2003 Freescale semiconductors, Inc.
*
*************************************************************************
*
*  FILE NAME  : LPASS_4STG_FLTR
*
*  PURPOSE    : LPASS_4STG_FLTR macros definition for CW compiler
*
*  AUTHOR     :  Andriy Tymkiv, Anatoly Khaynakov
*
***********************************************************************/

#ifndef __LPASS_4STG_FLTR_H
#define __LPASS_4STG_FLTR_H


/************************************************************************
* NAME: LPASS_4STG_FLTR
*
* DESCRIPTION: 	calculates the four stage low-pass filter of the 
*		src[0..size-1] array in dest[0..size-1] array with filter's
*		response that controlled by parameter `x'
*
* NOTE: 	The elements type is assumed to be FRAC32
*
*************************************************************************/

/*
	d0	y
	d1	cntr
	d2	cntr
	d3	y
	d4	y
	d5	y
	d6	coef b1
	d7	coef b2
	
	a0	dst
	a1	src
	a2	x
	a3	coef a0
	a4	coef a1 || b3
	a5	coef a2	|| b4

*/


#define LPASS_4STG_FLTR(dst,src,size,x) do {		\
		FRAC32 *b = dst;			\
		FRAC32 *a = src;			\
		long n = (size);			\
		long k = x;				\
	 	asm{					\
	 	  /* Save registers */\
			lea -60(a7),a7			;\
			movem.l d0-d7/a0-a5,(a7)	;\
			/* Set eMAC to fractional mode */\
			move.l #0x20,d0			;\
			move.l d0,MACSR			;\
			/* Load function variables */\
			move.l b,a0			;\
			move.l a,a1			;\
			move.l k,d6			;\
			move.l #0x7FFFFFFF,a3		;\
			sub.l d6,a3			;\
			move.l #0,ACC0			;\
			mac.l a3,a3,ACC0		;\
			movclr.l ACC0,a3		;\
			mac.l a3,a3,ACC0		;\
			movclr.l ACC0,a3		;\
			move.l d6,d7			;\
			mac.l d7,d7,ACC0		;\
			movclr.l ACC0,d7		;\
			mac.l d6,d7,ACC0		;\
			movclr.l ACC0,a4		;\
			mac.l d7,d7,ACC0		;\
			movclr.l ACC0,a5		;\
			asl.l %2,d6			;\
			asl.l %1,d7			;\
			move.l d7,d0			;\
			asl.l %1,d7			;\
			add.l d0,d7			;\
			add.l a4,a4			;\
			add.l a4,a4			;\
			/* Clean registers and accumulators */  \
			moveq.l %0,d0			;\
			moveq.l %0,d3			;\
			moveq.l %0,d4			;\
			moveq.l %0,d5			;\
			move.l #0,ACC0			;\
			move.l #0,ACC1			;\
			move.l #0,ACC2			;\
			move.l #0,ACC3			;\
			/* Load counter */  \
			move.l n,d1			;\
			move.l d1,d2			;\
			/* Load in d1 number of 4 operations */ \
			asr.l %2,d1			;\
			beq *+104			;\
			/* Perform the filter 4 by 4 operations */ \
			move.l (a1)+,a2			;\
			mac.l a3,a2,ACC0		;\
			macl.l d6,d0,(a1)+,a2,ACC0	;\
			msac.l d7,d3,ACC0		;\
			mac.l a4,d4,ACC0		;\
			msac.l a5,d5,ACC0		;\
			/* Store results and clear accumulators */ \
			movclr.l ACC0,d5		;\
			move.l d5,(a0)+			;\
			mac.l a3,a2,ACC0		;\
			macl.l d6,d5,(a1)+,a2,ACC0	;\
			msac.l d7,d0,ACC0		;\
			mac.l a4,d3,ACC0		;\
			msac.l a5,d4,ACC0		;\
			movclr.l ACC0,d4		;\
			move.l d4,(a0)+			;\
			mac.l a3,a2,ACC0		;\
			macl.l d6,d4,(a1)+,a2,ACC0	;\
			msac.l d7,d5,ACC0		;\
			mac.l a4,d0,ACC0		;\
			msac.l a5,d3,ACC0		;\
			movclr.l ACC0,d3		;\
			move.l d3,(a0)+			;\
			mac.l a3,a2,ACC0		;\
			macl.l d6,d3,(a1)+,a2,ACC0	;\
			msac.l d7,d4,ACC0		;\
			mac.l a4,d5,ACC0		;\
			msac.l a5,d0,ACC0		;\
			movclr.l ACC0,d0		;\
			move.l d0,(a0)+			;\
			subq.l %1,d1			;\
			bne *-98			;\
			/* Load in d2 number of operations left */\
			and.l %3,d2			;\
			beq *+36			;\
			/* Perform last operations */\
			mac.l a3,a2,ACC0		;\
			macl.l d6,d0,(a1)+,a2,ACC0	;\
			msac.l d7,d3,ACC0		;\
			mac.l a4,d4,ACC0		;\
			msac.l a5,d5,ACC0		;\
			move.l d4,d5			;\
			move.l d3,d4			;\
			move.l d0,d3			;\
			/* Store result and clear accumulator */ \
			movclr.l ACC0,d0		;\
			move.l d0,(a0)+			;\
			subq.l %1,d2			;\
			bne *-32			;\
			/* Restore registers */  \
			movem.l (a7),d0-d7/a0-a5	;\
			lea 60(a7),a7	    		;\
			};				\
		} while (0)


#endif // __LPASS_4STG_FLTR_H
