/************************************************************************
*
*  FREESCALE SEMICONDUCTORS INC.
*  ALL RIGHTS RESERVED
*  (c) Copyright 2003 Freescale semiconductors, Inc.
*
*************************************************************************
*
*  FILE NAME  : HPASS_1POLE_FLTR
*
*  PURPOSE    : HPASS_1POLE_FLTR macros definition for CW compiler
*
*  AUTHOR     :  Andriy Tymkiv, Anatoly Khaynakov
*
***********************************************************************/

#ifndef __HPASS_1POLE_FLTR_H
#define __HPASS_1POLE_FLTR_H


/************************************************************************
* NAME: HPASS_1POLE_FLTR
*
* DESCRIPTION: 	calculates the single pole high-pass filter of the 
*		src[0..size-1] array in dest[0..size-1] array with filter's
*		response that controlled by parameter `x'
*
* NOTE: 	The elements type is assumed to be FRAC32
*
*************************************************************************/

/*
	d0	y[i-1]
	d1	cntr
	d2	cntr
	d3	x[i]
	d4	x[i+1]
	d5	x[i+2]
	d6	coef b1
	d7	coef b2
	
	a0	dst
	a1	src
	a2	x[i+3]
	a3	coef a0
	a4	coef a1 || b3
	a5	coef a2	|| b4




*/


#define HPASS_1POLE_FLTR(dst,src,size,x) do {		\
		FRAC32 *b = dst;			\
		FRAC32 *a = src;			\
		long n = (size);			\
		long k = x;				\
	 	asm{					\
			/* Save registers */\
      lea -60(a7),a7			;\
			movem.l d0-d7/a0-a5,(a7)	;\
			/* Set eMAC to fractional mode */\
			move.l #0x20,d0			;\
			move.l d0,MACSR			;\
			/* Load function variables */\
			move.l b,a0			;\
			move.l a,a1			;\
			move.l k,d6			;\
			move.l d6,d7			;\
			asr.l %1,d7			;\
			add.l %0x3FFFFFFF,d7		;\
			move.l d7,a3			;\
			move.l (a1)+,d3			;\
			/* Clean registers and accumulators */  \
			move.l #0,d0			;\
			move.l #0,d4			;\
			move.l #0,ACC0			;\
			move.l #0,ACC1			;\
			move.l #0,ACC2			;\
			move.l #0,ACC3			;\
			/* Load counter */  \
			move.l n,d1			;\
			move.l d1,d2			;\
			/* Load in d1 number of 2 operations */ \
			asr.l %1,d1			;\
			beq *+38			;\
			/* Perform the filter 2 by 2 operations */ \
			mac.l a3,d3,ACC0		;\
			msac.l a3,d4,ACC0		;\
			macl.l d6,d0,(a1)+,d4,ACC0	;\
			movclr.l ACC0,d0		;\
			/* Store result and clear accumulator */ \
			move.l d0,(a0)+			;\
			mac.l a3,d4,ACC1		;\
			msac.l a3,d3,ACC1		;\
			macl.l d6,d0,(a1)+,d3,ACC1	;\
			movclr.l ACC1,d0		;\
			/* Store result and clear accumulator */ \
			move.l d0,(a0)+			;\
			subq.l %1,d1			;\
			bne *-34			;\
			/* Load in d2 number of operations left */\
			and.l %1,d2			;\
			beq *-18			;\
			/* Perform last operations */\
			mac.l a3,d3,ACC0		;\
			msac.l a3,d4,ACC0		;\
			mac.l d6,d0,ACC0		;\
			/* Store result and clear accumulator */ \
			movclr.l ACC0,d0		;\
			move.l d0,(a0)+			;\
			/* Restore registers */  \
			movem.l (a7),d0-d7/a0-a5	;\
			lea 60(a7),a7	    		;\
			};				\
		} while (0)


#endif // __HPASS_1POLE_FLTR_H
