/************************************************************************
*
*  FREESCALE SEMICONDUCTORS INC.
*  ALL RIGHTS RESERVED
*  (c) Copyright 2003 Freescale semiconductors, Inc.
*
*************************************************************************
*
*  FILE NAME  : ARR2D_MULSC.h
*
*  PURPOSE    : ARR2D_MULSC_{S,U}L macros definition for CW compiler
*
*  AUTHOR     :  Andriy Tymkiv, Anatoly Khaynakov
*
***********************************************************************/

#ifndef __ARR2D_MULSC_H
#define __ARR2D_MULSC_H


/************************************************************************
* NAME: ARR2D_MULSC_SL
*
* DESCRIPTION: 	[0..size1-1][0..size2-1] elements of `arr' array are 
*		multiplied by `scal' value:
*			arr[i][j] = arr[i][j] * scal
*
* NOTE: 	The elements type is assumed to be signed long
*************************************************************************/

#define ARR2D_MULSC_SL(arr,size1,size2,scal) do {	\
		long *a = (&arr[0][0]);		 	\
		long n1 = (size1);			\
		long n2 = (size2);			\
	 	long k = (scal);			\
	 	asm{					\
	 		/* Save registers */\
			lea -60(a7),a7			;\
			movem.l d0-d6/a0-a5,(a7)	;\
			/* Initialize MACSR register for signed operations */\
			move.l #0,d0			;\
			move.l d0,MACSR			;\
			/* Load function variables */\
			move.l a,a0			;\
			move.l k,d0			;\
			move.l n1,d1			;\
			move.l n2,d2			;\
			/* Load counter */  \
			mulu.l d2,d1			;\
			move.l d1,d2			;\
			/* Load in d1 number of 4 operations */ \
			asr.l %2,d1			;\
			beq *+66			;\
			/* Initialize eMAC accumulators */ \
			move.l #0,ACC0			;\
			move.l #0,ACC1			;\
			move.l #0,ACC2			;\
			move.l #0,ACC3			;\
			moveq.l %16,d7			;\
			/* Perform 4 by 4 operations as MUL */  \
			movem.l (a0),d3-d6		;\
			mac.l d0,d3,ACC0		;\
			mac.l d0,d4,ACC1		;\
			mac.l d0,d5,ACC2		;\
			mac.l d0,d6,ACC3		;\
			/* Store results and clear accumulators */ \
			movclr.l ACC0,d3		;\
			movclr.l ACC1,d4		;\
			movclr.l ACC2,d5		;\
			movclr.l ACC3,d6		;\
			movem.l d3-d6,(a0)		;\
			add.l d7,a0			;\
			subq.l %1,d1			;\
			bne *-36			;\
			/* Load in d2 number of operations left */\
			and.l %3,d2			;\
			beq *+14			;\
			/* Perform last operations as MUL */\
			move.l (a0),d3			;\
			muls.l d0,d3			;\
			move.l d3,(a0)+			;\
			subq.l %1,d2			;\
			bne *-10			;\
			/* Restore registers */  \
			movem.l (a7),d0-d6/a0-a5	;\
			lea 60(a7),a7	    		;\
			};				\
		} while (0)






/************************************************************************
* NAME: ARR2D_MULSC_UL
*
* DESCRIPTION: 	[0..size1-1][0..size2-1] elements of `arr' array are 
*		multiplied by `scal' value:
*			arr[i][j] = arr[i][j] * scal
*
* NOTE: 	The elements type is assumed to be unsigned long
*************************************************************************/


#define ARR2D_MULSC_UL(arr,size1,size2,scal) do {	\
		unsigned long *a = (&arr[0][0]); 	\
		long n1 = (size1);			\
		long n2 = (size2);			\
	 	unsigned long k = (scal);		\
	 	asm{					\
	 		/* Save registers */\
			lea -60(a7),a7			;\
			movem.l d0-d6/a0-a5,(a7)	;\
			/* Initialize MACSR register for unsigned operations */\
			move.l #0x40,d0			;\
			move.l d0,MACSR			;\
			/* Load function variables */\
			move.l a,a0			;\
			move.l k,d0			;\
			move.l n1,d1			;\
			move.l n2,d2			;\
			/* Load counter */  \
			mulu.l d2,d1			;\
			move.l d1,d2			;\
			/* Load in d1 number of 4 operations */ \
			asr.l %2,d1			;\
			beq *+66			;\
			/* Initialize eMAC accumulators */ \
			move.l #0,ACC0			;\
			move.l #0,ACC1			;\
			move.l #0,ACC2			;\
			move.l #0,ACC3			;\
			moveq.l %16,d7			;\
			/* Perform 4 by 4 operations as MUL */  \
			movem.l (a0),d3-d6		;\
			mac.l d0,d3,ACC0		;\
			mac.l d0,d4,ACC1		;\
			mac.l d0,d5,ACC2		;\
			mac.l d0,d6,ACC3		;\
			/* Store results and clear accumulators */ \
			movclr.l ACC0,d3		;\
			movclr.l ACC1,d4		;\
			movclr.l ACC2,d5		;\
			movclr.l ACC3,d6		;\
			movem.l d3-d6,(a0)		;\
			add.l d7,a0			;\
			subq.l %1,d1			;\
			bne *-36			;\
			/* Load in d2 number of operations left */\
			and.l %3,d2			;\
			beq *+14			;\
			/* Perform last operations as MUL */\
			move.l (a0),d3			;\
			mulu.l d0,d3			;\
			move.l d3,(a0)+			;\
			subq.l %1,d2			;\
			bne *-10			;\
			/* Restore registers */  \
			movem.l (a7),d0-d6/a0-a5	;\
			lea 60(a7),a7	    		;\
			};				\
		} while (0)



#endif // __ARR2D_MULSC_H