/************************************************************************
*
*  FREESCALE INC.
*  ALL RIGHTS RESERVED
*  (c) Copyright 2004 Freescale, Inc.
*
*************************************************************************
*
*  FILE NAME  : ARR1D_PROD.h
*
*  PURPOSE    : ARR1D_PROD_{S,U}L macros definition for CW compiler
*
*  AUTHOR     :  Andriy Tymkiv, Anatoly Khaynakov
*
***********************************************************************/

#ifndef __ARR1D_PROD_H
#define __ARR1D_PROD_H


/************************************************************************
* NAME: ARR1D_PROD_SL
*
* DESCRIPTION: 	
*
* NOTE: 	The elements type is assumed to be signed long
*************************************************************************/

#define ARR1D_PROD_SL(arr,size) ({		 \
		long *a = (arr);		 \
		long s = (size);	 	 \
		unsigned long res = 0;		 \
		asm{				 \
			/* Save registers */\
			lea -60(a7),a7		;\
			movem.l d0-d2/a0,(a7)	;\
			/* Load function variables */\
			move.l a,a0		;\
			move.l s,d1		;\
			/* Load counter, initialize d0 */  \
			move.l d1,d2		;\
			moveq.l %1,d0		;\
			/* Load in d1 number of 4 operations */ \
			asr.l %2,d1		;\
			beq out1		;\
		loop1:				;\
			/* Perform 4 by 4 operations as PROD */  \
			muls.l (a0)+,d0		;\
			muls.l (a0)+,d0		;\
			muls.l (a0)+,d0		;\
			muls.l (a0)+,d0		;\
			subq.l %1,d1		;\
			bne loop1		;\
		out1:				;\
			/* Load in d2 number of operations left */  \
			and.l %3,d2		;\
			beq out2		;\
		loop2:				;\
			/* Preform last operations as PROD */  \
			muls.l (a0)+,d0		;\
			subq.l %1,d2		;\
			bne loop2		;\
		out2:				;\
			/* Load result */  \
			move.l d0,res		;\
			/* Restore registers */  \
			movem.l (a7),d0-d2/a0	;\
			lea 60(a7),a7	    	;\
			};			 \
		res; })




/************************************************************************
* NAME: ARR1D_PROD_UL
*
* DESCRIPTION: 	
*
* NOTE: 	The elements type is assumed to be unsigned long
*************************************************************************/

#define ARR1D_PROD_UL(arr,size) ({		 \
		unsigned long *a = (arr);	 \
		long s = (size);	 	 \
		unsigned long res = 0;		 \
		asm{				 \
			/* Save registers */\
			lea -60(a7),a7		;\
			movem.l d0-d2/a0,(a7)	;\
			/* Load function variables */\
			move.l a,a0		;\
			move.l s,d1		;\
			/* Load counter, initialize d0 */  \
			move.l d1,d2		;\
			moveq.l %1,d0		;\
			/* Load in d1 number of 4 operations */ \
			asr.l %2,d1		;\
			beq out1		;\
		loop1:				;\
			/* Perform 4 by 4 operations as PROD */  \
			mulu.l (a0)+,d0		;\
			mulu.l (a0)+,d0		;\
			mulu.l (a0)+,d0		;\
			mulu.l (a0)+,d0		;\
			subq.l %1,d1		;\
			bne loop1		;\
		out1:				;\
			/* Load in d2 number of operations left */  \
			and.l %3,d2		;\
			beq out2		;\
		loop2:				;\
			/* Preform last operations as PROD */  \
			mulu.l (a0)+,d0		;\
			subq.l %1,d2		;\
			bne loop2		;\
		out2:				;\
			/* Load result */  \
			move.l d0,res		;\
			/* Restore registers */  \
			movem.l (a7),d0-d2/a0	;\
			lea 60(a7),a7	    	;\
			};			 \
		res; })







#endif //__ARR1D_PROD_H

