/************************************************************************
*
*  FREESCALE SEMICONDUCTORS INC.
*  ALL RIGHTS RESERVED
*  (c) Copyright 2003 Freescale semiconductors, Inc.
*
*************************************************************************
*
*  FILE NAME  : ARR_MAX_MIN.h
*
*  PURPOSE    : ARR_MAX_,ARR_MIN_ macros definition for CW compiler
*
*  AUTHOR     : Artem Kovalev
*
***********************************************************************/

#ifndef __ARR2DI_MAX_MIN_H
#define __ARR2DI_MAX_MIN_H

#pragma gcc_extensions on

/************************************************************************
* NAME: ARR_MAX_S
*
* DESCRIPTION: finds maximum element of 2D array and returns index of it
*		or if there are no maximum element (all elements are 
*		equal) it returns 0 (index of first element). Index is
*		linear
*
* NOTE: 	The elements type of the source array is assumed to be
*			signed long
*************************************************************************/
#define IMPL_ARR2D_MAX_S(src,size1,size2) ({								\
						signed long *a = (&src[0][0]);				\
						int s1 = (size1);					\
						int s2 = (size2);						\
						int res = 0;							\
						asm{								 \
								/* Save registers */\
								lea 	-60(a7),a7			;\
								movem.l d0-d7/a0-a2,(a7)	;\
								/* Load function variables and initial values */\
								move.l  a,a0				;\
								move.l	s1,d0				;\
								move.l  s2,d7				;\
								mulu.l  d7,d0				;\
								move.l  (a0)+,d5			;\
								subq.l  %1,d0				;\
								clr.l   d6					;\
								clr.l   res					;\
								/* Load counter */  \
								move.l  d0,d7				;\
								/* Load in d0 number of 4 comparisons */ \
								asr.l   %2,d0				;\
							beq *+80						;\
								/* Perform 4 by 4 comparisons */ \
								/* Load from d1 to d4, four source numbers */  \
								movem.l (a0),d1-d4			;\
								/* Compare d1 with d5 and store in res the index of the higher value */  \
								cmp.l   d1,d5				;\
								bge     *+12				;\
								move.l  d1,d5				;\
								addq.l  %1,d6				;\
								move.l  d6,res				;\
								bra *+4						;\
								addq.l  %1,d6				;\
						    	/* Compare d2 with d5 and store in res the index of the higher value */  \
						    	cmp.l   d2,d5				;\
								bge   *+12					;\
								move.l  d2,d5				;\
								addq.l  %1,d6				;\
								move.l  d6,res				;\
								bra *+4						;\
							    addq.l  %1,d6				;\
						    	/* Compare d3 with d5 and store in res the index of the higher value */  \
						    	cmp.l   d3,d5				;\
								bge   *+12					;\
								move.l  d3,d5				;\
								addq.l  %1,d6				;\
								move.l  d6,res				;\
								bra *+4						;\
							    addq.l  %1,d6				;\
						    	/* Compare d4 with d5 and store in res the index of the higher value */  \
						    	cmp.l   d4,d5				;\
								bge *+12					;\
								move.l  d4,d5				;\
								addq.l  %1,d6				;\
								move.l  d6,res				;\
								bra *+4						;\
							    addq.l  %1,d6				;\
						    	add.l   %16,a0				;\
								subq.l  %1,d0				;\
							bne *-76						;\
								/* Load in d7 number of comparisons left */  \
								and.l %3,d7					;\
							beq *+28						;\
								/* Perform the comparisons left */ \
								move.l (a0)+,d1				;\
								/* Compare d1 with d5 and store in res the index of the higher value */  \
								cmp.l  d1,d5				;\
								bge *+16					;\
								move.l  d1,d5				;\
								addq.l  %1,d6				;\
								move.l  d6,res				;\
								subq.l  %1,d7				;\
								beq *-16					;\
								bra *+8						;\
								addq.l  %1,d6				;\
								subq.l  %1,d7				;\
								bne *-24					;\
								/* Restore registers */  \
								movem.l  (a7),d0-d7/a0-a2	;\
								lea      60(a7),a7			;\
								};							;\
								res;})
/************************************************************************
* NAME: ARR_MIN_S
*
* DESCRIPTION: 	finds minimum element of 2d array and returns index of it
*		or if there are no minimum element (all elements are 
*		equal) it returns 0 (index of first element). Index is linear
*
* NOTE: 	The elements type of sorce array is assumed to
*			be signed long
*************************************************************************/
#define IMPL_ARR2D_MIN_S(src,size1,size2) ({								\
						signed long *a = (&src[0][0]);				\
						int s1 = (size1);					\
						int s2 = (size2);						\
						int res = 0;							\
						asm{								 \
								/* Save registers */\
								lea 	-60(a7),a7			;\
								movem.l d0-d7/a0-a2,(a7)	;\
								/* Load function variables and initial values */\
								move.l  a,a0				;\
								move.l	s1,d0				;\
								move.l  s2,d7				;\
								mulu.l  d7,d0				;\
								move.l  (a0)+,d5			;\
								subq.l  %1,d0				;\
								clr.l   d6					;\
								clr.l   res					;\
								/* Load counter */  \
								move.l  d0,d7				;\
								/* Load in d0 number of 4 comparisons */ \
								asr.l   %2,d0				;\
							beq *+80						;\
								/* Perform 4 by 4 comparisons */ \
								/* Load from d1 to d4, four source numbers */  \
								movem.l (a0),d1-d4			;\
								/* Compare d1 with d5 and store in res the index of the lower value */  \
								cmp.l   d1,d5				;\
								ble     *+12				;\
								move.l  d1,d5				;\
								addq.l  %1,d6				;\
								move.l  d6,res				;\
								bra *+4						;\
								addq.l  %1,d6				;\
						     	/* Compare d2 with d5 and store in res the index of the lower value */  \
						     	cmp.l   d2,d5				;\
								ble   *+12					;\
								move.l  d2,d5				;\
								addq.l  %1,d6				;\
								move.l  d6,res				;\
								bra *+4						;\
							    addq.l  %1,d6				;\
						    	/* Compare d3 with d5 and store in res the index of the lower value */  \
						    	cmp.l   d3,d5				;\
								ble   *+12					;\
								move.l  d3,d5				;\
								addq.l  %1,d6				;\
								move.l  d6,res				;\
								bra *+4						;\
							    addq.l  %1,d6				;\
						    	/* Compare d4 with d5 and store in res the index of the lower value */  \
						    	cmp.l   d4,d5				;\
								ble *+12					;\
								move.l  d4,d5				;\
								addq.l  %1,d6				;\
								move.l  d6,res				;\
								bra *+4						;\
							    addq.l  %1,d6				;\
						    	add.l   %16,a0				;\
								subq.l  %1,d0				;\
							bne *-76						;\
								/* Load in d7 number of comparisons left */  \
								and.l %3,d7					;\
							beq *+28						;\
								/* Perform the comparisons left */ \
								move.l (a0)+,d1				;\
								/* Compare d1 with d5 and store in res the index of the lower value */  \
								cmp.l  d1,d5				;\
								ble *+16					;\
								move.l  d1,d5				;\
								addq.l  %1,d6				;\
								move.l  d6,res				;\
								subq.l  %1,d7				;\
								beq *-16					;\
								bra *+8					    ;\
								addq.l  %1,d6				;\
								subq.l  %1,d7				;\
								bne *-24					;\
								/* Restore registers */  \
								movem.l  (a7),d0-d7/a0-a2	;\
								lea      60(a7),a7			;\
								};							;\
								res;})
								
/************************************************************************
* NAME: ARR_MAX_U
*
* DESCRIPTION: finds maximum element of array and returns index of it
*			   or if there are no maximum element (all elements are 
*			   equal) it returns 0 (index of first element)
*
* NOTE: 	The elements type of the source array is assumed to be
*			unsigned long
*************************************************************************/
#define IMPL_ARR2D_MAX_U(src,size1,size2) ({								\
						unsigned long *a = (&src[0][0]);				\
						int s1 = (size1);					\
						int s2 = (size2);						\
						int res = 0;							\
						asm{								 \
								/* Save registers */\
								lea 	-60(a7),a7			;\
								movem.l d0-d7/a0-a2,(a7)	;\
								/* Load function variables and initial values */\
								move.l  a,a0				;\
								move.l	s1,d0				;\
								move.l  s2,d7				;\
								mulu.l  d7,d0				;\
								move.l  (a0)+,d5			;\
								subq.l  %1,d0				;\
								clr.l   d6					;\
								clr.l   res					;\
								/* Load counter */  \
								move.l  d0,d7				;\
								/* Load in d0 number of 4 comparisons */ \
								asr.l   %2,d0				;\
							beq *+80						;\
								/* Perform 4 by 4 comparisons */ \
								/* Load from d1 to d4, four source numbers */  \
								movem.l (a0),d1-d4			;\
								/* Compare d1 with d5 and store in res the index of the higher value */  \
								cmp.l   d1,d5				;\
								bhi     *+12				;\
								move.l  d1,d5				;\
								addq.l  %1,d6				;\
								move.l  d6,res				;\
								bra *+4						;\
								addq.l  %1,d6				;\
						    	/* Compare d2 with d5 and store in res the index of the higher value */  \
						    	cmp.l   d2,d5				;\
								bhi   *+12					;\
								move.l  d2,d5				;\
								addq.l  %1,d6				;\
								move.l  d6,res				;\
								bra *+4						;\
							    addq.l  %1,d6				;\
						    	/* Compare d3 with d5 and store in res the index of the higher value */  \
						    	cmp.l   d3,d5				;\
								bhi   *+12					;\
								move.l  d3,d5				;\
								addq.l  %1,d6				;\
								move.l  d6,res				;\
								bra *+4						;\
							    addq.l  %1,d6				;\
						    	/* Compare d4 with d5 and store in res the index of the higher value */  \
						    	cmp.l   d4,d5				;\
								bhi *+12					;\
								move.l  d4,d5				;\
								addq.l  %1,d6				;\
								move.l  d6,res				;\
								bra *+4						;\
							    addq.l  %1,d6				;\
						    	add.l   %16,a0				;\
								subq.l  %1,d0				;\
							bne *-76						;\
								/* Load in d7 number of comparisons left */  \
								and.l %3,d7					;\
							beq *+28						;\
								/* Perform the comparisons left */ \
								move.l (a0)+,d1				;\
								/* Compare d1 with d5 and store in res the index of the higher value */  \
								cmp.l  d1,d5				;\
								bhi *+16					;\
								move.l  d1,d5				;\
								addq.l  %1,d6				;\
								move.l  d6,res				;\
								subq.l  %1,d7				;\
								beq *-16					;\
								bra *+8						;\
								addq.l  %1,d6				;\
								subq.l  %1,d7				;\
								bne *-24					;\
								/* Restore registers */  \
								movem.l  (a7),d0-d7/a0-a2	;\
								lea      60(a7),a7			;\
								};							;\
								res;})
								
/************************************************************************
* NAME: ARR_MIN_U
*
* DESCRIPTION: 	finds minimum element of array and returns index of it
*			   or if there are no minimum element (all elements are 
*			   equal) it returns 0 (index of first element)
*
* NOTE: 	The elements type of source array is assumed to
*       	be unsigned long
*************************************************************************/
#define IMPL_ARR2D_MIN_U(src,size1,size2) ({								\
						unsigned long *a = (&src[0][0]);				\
						int s1 = (size1);					\
						int s2 = (size2);						\
						int res = 0;							\
						asm{								 \
								/* Save registers */\
								lea 	-60(a7),a7			;\
								movem.l d0-d7/a0-a2,(a7)	;\
								/* Load function variables and initial values */\
								move.l  a,a0				;\
								move.l	s1,d0				;\
								move.l  s2,d7				;\
								mulu.l  d7,d0				;\
								move.l  (a0)+,d5			;\
								subq.l  %1,d0				;\
								clr.l   d6					;\
								clr.l   res					;\
								/* Load counter */  \
								move.l  d0,d7				;\
								/* Load in d0 number of 4 comparisons */ \
								asr.l   %2,d0				;\
							beq *+80						;\
								/* Perform 4 by 4 comparisons */ \
								/* Load from d1 to d4, four source numbers */  \
								movem.l (a0),d1-d4			;\
								/* Compare d1 with d5 and store in res the index of the lower value */  \
								cmp.l   d1,d5				;\
								bls     *+12				;\
								move.l  d1,d5				;\
								addq.l  %1,d6				;\
								move.l  d6,res				;\
								bra *+4						;\
								addq.l  %1,d6				;\
						     	/* Compare d2 with d5 and store in res the index of the lower value */  \
						     	cmp.l   d2,d5				;\
								bls   *+12					;\
								move.l  d2,d5				;\
								addq.l  %1,d6				;\
								move.l  d6,res				;\
								bra *+4						;\
							    addq.l  %1,d6				;\
						    	/* Compare d3 with d5 and store in res the index of the lower value */  \
						    	cmp.l   d3,d5				;\
								bls   *+12					;\
								move.l  d3,d5				;\
								addq.l  %1,d6				;\
								move.l  d6,res				;\
								bra *+4						;\
							    addq.l  %1,d6				;\
						    	/* Compare d4 with d5 and store in res the index of the lower value */  \
						    	cmp.l   d4,d5				;\
								bls *+12					;\
								move.l  d4,d5				;\
								addq.l  %1,d6				;\
								move.l  d6,res				;\
								bra *+4						;\
							    addq.l  %1,d6				;\
						    	add.l   %16,a0				;\
								subq.l  %1,d0				;\
							bne *-76						;\
								/* Load in d7 number of comparisons left */  \
								and.l %3,d7					;\
							beq *+28						;\
								/* Perform the comparisons left */ \
								move.l (a0)+,d1				;\
								/* Compare d1 with d5 and store in res the index of the lower value */  \
								cmp.l  d1,d5				;\
								bls *+16					;\
								move.l  d1,d5				;\
								addq.l  %1,d6				;\
								move.l  d6,res				;\
								subq.l  %1,d7				;\
								beq *-16					;\
								bra *+8					    ;\
								addq.l  %1,d6				;\
								subq.l  %1,d7				;\
								bne *-24					;\
								/* Restore registers */  \
								movem.l  (a7),d0-d7/a0-a2	;\
								lea      60(a7),a7			;\
								};							;\
								res;})

#define ARR2D_MAX_IS(m_src,size1,size2,ind1,ind2) ({\
		int *m_ind1 = (ind1);	\
		int *m_ind2 = (ind2);	\
		int index = 0;								\
		index = IMPL_ARR2D_MAX_S(m_src,size1,size2);\
		/* Load index1 and index2 of maximum element */\
		*m_ind1 = index/(size1);						\
		*m_ind2 = index - ((size2) * (*m_ind1));\
		})

#define ARR2D_MAX_IU(m_src,size1,size2,ind1,ind2) ({\
		int *m_ind1 = (ind1);	\
		int *m_ind2 = (ind2);	\
		int index = 0;								\
		index = IMPL_ARR2D_MAX_U(m_src,size1,size2);\
		/* Load index1 and index2 of maximum element */\
		*m_ind1 = index/(size1);\
		*m_ind2 = index - ((size2) * (*m_ind1));\
		})

#define ARR2D_MIN_IS(m_src,size1,size2,ind1,ind2) ({\
		int *m_ind1 = (ind1);	\
		int *m_ind2 = (ind2);	\
		int index = 0;	\
		index = IMPL_ARR2D_MIN_S(m_src,size1,size2);\
		/* Load index1 and index2 of minimum element */\
		*m_ind1 = index/(size1);	\
		*m_ind2 = index - ((size2) * (*m_ind1));\
		})

#define ARR2D_MIN_IU(m_src,size1,size2,ind1,ind2) ({\
		int *m_ind1 = (ind1);		\
		int *m_ind2 = (ind2);		\
		int index = 0;		\
		index = IMPL_ARR2D_MIN_U(m_src,size1,size2);\
		/* Load index1 and index2 of minimum element */\
		*m_ind1 = index/(size1);	\
		*m_ind2 = index - ((size2) * (*m_ind1));\
		})

#endif //__ARR2DI_MAX_MIN_H

