/************************************************************************
*
*  FREESCALE SEMICONDUCTORS INC.
*  ALL RIGHTS RESERVED
*  (c) Copyright 2003 Freescale semiconductors, Inc.
*
*************************************************************************
*
*  FILE NAME  : ARR2D_PROD.h
*
*  PURPOSE    : ARR2D_PROD_{S,U}L macros definition for CW compiler
*
*  AUTHOR     :  Andriy Tymkiv, Anatoly Khaynakov
*
***********************************************************************/

#ifndef __ARR2D_PROD_H
#define __ARR2D_PROD_H


/************************************************************************
* NAME: ARR2D_PROD_SL
*
* DESCRIPTION: 	returns the product of [0..size1-1][0..size2-1] elements 
*		of the `arr' array
*
* NOTE: 	The elements type is assumed to be signed long
*************************************************************************/

#define ARR2D_PROD_SL(arr,size1,size2) ({	 \
		long *a = (&arr[0][0]);		 \
		long s1 = (size1);	 	 \
		long s2 = (size2);	 	 \
		unsigned long res = 0;		 \
		asm{				 \
			/* Save registers */\
			lea -60(a7),a7		;\
			movem.l d0-d2/a0,(a7)	;\
			/* Load function variables */\
			move.l a,a0		;\
			move.l s1,d1		;\
			move.l s2,d2		;\
			/* Load counter, initialize d0 */  \
			mulu.l d2,d1		;\
			move.l d1,d2		;\
			moveq.l %1,d0		;\
			/* Load in d1 number of 4 operations */ \
			asr.l %2,d1		;\
			beq *+22 		;\
			/* Perform 4 by 4 operations as PROD */  \
			muls.l (a0)+,d0		;\
			muls.l (a0)+,d0		;\
			muls.l (a0)+,d0		;\
			muls.l (a0)+,d0		;\
			subq.l %1,d1		;\
			bne *-18		;\
			/* Load in d2 number of operations left */  \
			and.l %3,d2		;\
			beq *+10		;\
			/* Perform last operations as PROD */  \
			muls.l (a0)+,d0		;\
			subq.l %1,d2		;\
			bne *-6		;\
			/* Load result */  \
			move.l d0,res		;\
			/* Restore registers */  \
			movem.l (a7),d0-d2/a0	;\
			lea 60(a7),a7	    	;\
			};			 \
		res; })




/************************************************************************
* NAME: ARR2D_PROD_UL
*
* DESCRIPTION: 	returns the product of [0..size1-1][0..size2-1] elements 
*		of the `arr' array
*
* NOTE: 	The elements type is assumed to be unsigned long
*************************************************************************/


#define ARR2D_PROD_UL(arr,size1,size2) ({	 \
		unsigned long *a = (&arr[0][0]); \
		long s1 = (size1);	 	 \
		long s2 = (size2);	 	 \
		unsigned long res = 0;		 \
		asm{				 \
			/* Save registers */\
			lea -60(a7),a7		;\
			movem.l d0-d2/a0,(a7)	;\
			/* Load function variables */\
			move.l a,a0		;\
			move.l s1,d1		;\
			move.l s2,d2		;\
			/* Load counter, initialize d0 */  \
			mulu.l d2,d1		;\
			move.l d1,d2		;\
			moveq.l %1,d0		;\
			/* Load in d1 number of 4 operations */ \
			asr.l %2,d1		;\
			beq *+22 		;\
			/* Perform 4 by 4 operations as PROD */  \
			mulu.l (a0)+,d0		;\
			mulu.l (a0)+,d0		;\
			mulu.l (a0)+,d0		;\
			mulu.l (a0)+,d0		;\
			subq.l %1,d1		;\
			bne *-18 		;\
			/* Load in d2 number of operations left */  \
			and.l %3,d2		;\
			beq *+10		;\
			/* Perform last operations as PROD */  \
			mulu.l (a0)+,d0		;\
			subq.l %1,d2		;\
			bne *-6 	;\
			/* Load result */  \
			move.l d0,res		;\
			/* Restore registers */  \
			movem.l (a7),d0-d2/a0	;\
			lea 60(a7),a7	    	;\
			};			 \
		res; })







#endif //__ARR2D_PROD_H

