/************************************************************************
*
*  FREESCALE SEMICONDUCTORS INC.
*  ALL RIGHTS RESERVED
*  (c) Copyright 2003 Freescale semiconductors, Inc.
*
*************************************************************************
*
*  FILE NAME  : ARR_CAST.h
*
*  PURPOSE    : CONVERT_ARR_{SWL}{UWL} macros definition for CW compiler
*
*  AUTHOR     : Artem Kovalev
*
***********************************************************************/

#ifndef __ARR2D_CAST_H
#define __ARR2D_CAST_H

#pragma gcc_extensions on

/************************************************************************
* NAME: CONVERT_ARR_SWL
*
* DESCRIPTION: converts source array[0..size1-1][0..size2-1] from signed 
*		short to signed int and stores it in destination array.
*
* NOTE: 	The elements type of the source array is assumed to be
*			signed short
*************************************************************************/

#define ARR2D_CAST_SWL(src,dest,size1,size2) do {					\
						signed short *a = (&src[0][0]);			\
						signed long   *b = (&dest[0][0]);			\
						int s1 = (size1);						\
						int s2 = (size2);					\
						asm{								\
								/* Save registers */\
								lea 	-60(a7),a7			;\
								movem.l d0-d6/a0-a2,(a7)	;\
								/* Load function variables */\
								move.l  a,a0				;\
								move.l  b,a1				;\
								move.l	s1,d0				;\
								move.l  s2,d6				;\
								/* Load counter */  \
								mulu.l  d6,d0				;\
								move.l  d0,d6				;\
								/* Load in d0 number of 4 operations */ \
								asr.l   %2,d0				;\
							beq.s    *+38   					;\
								/* Perform 4 by 4 operations as signed cast */  \
								movem.l (a0),d2/d4			;\
								move.l  d2,d3				;\
								move.l  d4,d5				;\
								swap.w  d2					;\
								swap.w  d4					;\
								ext.l   d2					;\
								ext.l   d3					;\
								ext.l   d4					;\
								ext.l   d5					;\
								/* Store results */ \
								movem.l d2-d5,(a1)			;\
								addq.l  %8,a0				;\
								add.l   %16,a1				;\
								subq.l  %1,d0				;\
							bne.s    *-34   					;\
								/* Load in d6 number of operations left */  \
								and.l   %3,d6				;\
							beq.s    *+12 					;\
								/* Perform last operations as signed cast */  \
								move.w  (a0)+,d2			;\
								ext.l   d2					;\
								move.l  d2,(a1)+			;\
								subq.l  %1,d6				;\
							bne.s    *-8    					;\
								/* Restore registers */  \
								movem.l  (a7),d0-d6/a0-a2	;\
								lea      60(a7),a7			;\
								};							 \
								} while(0);
								
/************************************************************************
* NAME: CONVERT_ARR_UWL
*
* DESCRIPTION: 	converts source array[0..size1-1][0..size2-1] from 
*		unsigned short to unsigned int and stores it in destination 
*		array.
*
* NOTE: 	The elements type is assumed to be unsigned short
*************************************************************************/

#define ARR2D_CAST_UWL(src,dest,size1,size2) do {					\
						unsigned short *a = (&src[0][0]);			\
						unsigned long   *b = (&dest[0][0]);			\
						int s1 = (size1);						\
						int s2 = (size2);						\
						asm{								 \
								/* Save registers */\
								lea 	-60(a7),a7			;\
								movem.l d0-d6/a0-a2,(a7)	;\
								/* Load function variables */\
								move.l  a,a0				;\
								move.l  b,a1				;\
								move.l	s1,d0				;\
								move.l  s2,d6				;\
								/* Load counter */  \
								mulu.l  d6,d0				;\
								move.l  d0,d6				;\
								/* Load in d0 number of 4 operations */ \
								asr.l   %2,d0				;\
							beq.s    *+54					;\
								/* Perform 4 by 4 operations as unsigned cast */  \
								movem.l (a0),d2/d4			;\
								move.l  d2,d3				;\
								move.l  d4,d5				;\
								swap.w  d2					;\
								swap.w  d4					;\
								andi.l  %0xffff,d2			;\
								andi.l  %0xffff,d3			;\
								andi.l  %0xffff,d4			;\
								andi.l  %0xffff,d5			;\
								/* Store results */ \
								movem.l d2-d5,(a1)			;\
								addq.l  %8,a0				;\
								add.l   %16,a1				;\
								subq.l  %1,d0				;\
							bne.s    *-50 					;\
								/* Load in d6 number of operations left */  \
								and.l   %3,d6				;\
							beq.s     *+16 					;\
								/* Perform last operations as unsigned cast */  \
								move.w  (a0)+,d2			;\
								andi.l  %0xffff,d2			;\
								move.l  d2,(a1)+			;\
								subq.l  %1,d6				;\
							bne.s    *-12 					;\
								/* Restore registers */  \
								movem.l  (a7),d0-d6/a0-a2	;\
								lea      60(a7),a7			;\
								};							 \
								} while(0);
#endif //__ARR2D_CAST_H