/************************************************************************
*
*  FREESCALE SEMICONDUCTORS INC.
*  ALL RIGHTS RESERVED
*  (c) Copyright 2003 Freescale semiconductors, Inc.
*
*************************************************************************
*
*  FILE NAME  : ARR1D_SUM.h
*
*  PURPOSE    : ARR1D_SUM_{S,U}L macros definition for CW compiler
*
*  AUTHOR     :  Andriy Tymkiv, Anatoly Khaynakov
*
***********************************************************************/

#ifndef __ARR1D_SUM_H
#define __ARR1D_SUM_H


/************************************************************************
* NAME: ARR1D_SUM_SL
*
* DESCRIPTION: 	returns the summ of [0..size-1] elements of the `arr' array
*
* NOTE: 	The elements type is assumed to be signed long
*************************************************************************/

#define ARR1D_SUM_SL(arr,size) ({			 \
		long *a = (arr);			 \
		long s = (size);			 \
	 	long res = 0;			 \
	 	asm{				 \
	 		/* Save registers */\
			lea -60(a7),a7		;\
			movem.l d0-d2/a0,(a7)	;\
			/* Load function variables */\
			move.l a,a0		;\
			move.l s,d1		;\
			/* Load counter, initialize d0 */  \
			move.l d1,d2		;\
			clr.l d0		;\
			/* Load in d1 number of 4 operations */ \
			asr.l #2,d1		;\
			beq *+14		;\
			/* Perform 4 by 4 operations as SUM */  \
			add.l (a0)+,d0		;\
			add.l (a0)+,d0		;\
			add.l (a0)+,d0		;\
			add.l (a0)+,d0		;\
			subq.l #1,d1		;\
			bne *-10		;\
			/* Load in d2 number of operations left */  \
			and.l #3,d2		;\
			beq *+8			;\
			/* Preform the last operations as SUM */  \
			add.l (a0)+,d0		;\
			subq.l #1,d2		;\
			bne *-4			;\
			/* Load result */  \
			move.l d0,res		;\
			/* Restore registers */  \
			movem.l (a7),d0-d2/a0	;\
			lea 60(a7),a7	    	;\
			};			 \
		res; })


/************************************************************************
* NAME: ARR1D_SUM_UL
*
* DESCRIPTION: 	returns the summ of [0..size-1] elements of the `arr' array
*
* NOTE: 	The elements type is assumed to be unsigned long
*************************************************************************/

#define ARR1D_SUM_UL(arr,size) ({		 \
		unsigned long *a = (arr);	 \
		long s = (size);	 	 \
		unsigned long res = 0;		 \
		asm{				 \
			/* Save registers */\
			lea -60(a7),a7		;\
			movem.l d0-d2/a0,(a7)	;\
			/* Load function variables */\
			move.l a,a0		;\
			move.l s,d1		;\
			/* Load counter, initialize d0 */  \
			move.l d1,d2		;\
			clr.l d0		;\
			/* Load in d1 number of 4 operations */ \
			asr.l #2,d1		;\
			beq *+14		;\
			/* Perform 4 by 4 operations as SUM */  \
			add.l (a0)+,d0		;\
			add.l (a0)+,d0		;\
			add.l (a0)+,d0		;\
			add.l (a0)+,d0		;\
			subq.l #1,d1		;\
			bne *-10		;\
			/* Load in d2 number of operations left */  \
			and.l #3,d2		;\
			beq *+8			;\
			/* Preform the last operations as SUM */  \
			add.l (a0)+,d0		;\
			subq.l #1,d2		;\
			bne *-4			;\
			/* Load result */  \
			move.l d0,res		;\
			/* Restore registers */  \
			movem.l (a7),d0-d2/a0	;\
			lea 60(a7),a7	    	;\
			};			 \
		res; })



#endif //__ARR1D_SUM_H

