/************************************************************************
*
*  FREESCALE SEMICONDUCTORS INC.
*  ALL RIGHTS RESERVED
*  (c) Copyright 2003 Freescale semiconductors, Inc.
*
*************************************************************************
*
*  FILE NAME  : ARR1D_ADDSC.h
*
*  PURPOSE    : ARR1D_ADDSC_{S,U}L macros definition for CW compiler
*
*  AUTHOR     :  Andriy Tymkiv, Anatoly Khaynakov
*
***********************************************************************/

#ifndef __ARR1D_ADDSC_H
#define __ARR1D_ADDSC_H


/************************************************************************
* NAME: ARR1D_ADDSC_UL
*
* DESCRIPTION: 	adds `scal' value to [0..size-1] elements of `arr' array:
*			arr[i] = arr[i] + scal
*
* NOTE: 	The elements type is assumed to be unsigned long
*************************************************************************/


#define ARR1D_ADDSC_UL(arr,size,scal) do {		\
		unsigned long *a = (arr);	 	\
		long n = (size);			\
	 	unsigned long k = (scal);		\
	 	asm{					\
			/* Save registers */\
			lea -60(a7),a7			;\
			movem.l d0-d2/a0,(a7)		;\
			/* Load function variables */\
			move.l a,a0			;\
			move.l k,d0			;\
			move.l n,d1			;\
			/* Load counter */  \
			move.l d1,d2			;\
			/* Load in d1 number of 4 operations */ \
			asr.l %2,d1			;\
			beq *+14			;\
			/* Perform 4 by 4 operations as SUM */  \
			add.l d0,(a0)+			;\
			add.l d0,(a0)+			;\
			add.l d0,(a0)+			;\
			add.l d0,(a0)+			;\
			subq.l %1,d1			;\
			bne *-10			;\
			/* Load in d2 number of operations left */  \
			and.l %3,d2			;\
			beq *+8				;\
			/* Perform last operations as SUM */  \
			add.l d0,(a0)+			;\
			subq.l %1,d2			;\
			bne *-4				;\
			/* Restore registers */  \
			movem.l (a7),d0-d2/a0		;\
			lea 60(a7),a7	    		;\
			};				\
		} while (0)


/************************************************************************
* NAME: ARR1D_ADDSC_SL
*
* DESCRIPTION: 	adds `scal' value to [0..size-1] elements of `arr' array:
*			arr[i] = arr[i] + scal
*
* NOTE: 	The elements type is assumed to be signed long
*************************************************************************/

#define ARR1D_ADDSC_SL(arr,size,scal) do {		\
		long *a = (arr);			\
		long n = (size);			\
	 	long k = (scal);			\
	 	asm{					\
			/* Save registers */\
			lea -60(a7),a7			;\
			movem.l d0-d2/a0,(a7)		;\
			/* Load function variables */\
			move.l a,a0			;\
			move.l k,d0			;\
			move.l n,d1			;\
			/* Load counter */  \
			move.l d1,d2			;\
			/* Load in d1 number of 4 operations */ \
			asr.l %2,d1			;\
			beq *+14			;\
			/* Perform 4 by 4 operations as SUM */  \
			add.l d0,(a0)+			;\
			add.l d0,(a0)+			;\
			add.l d0,(a0)+			;\
			add.l d0,(a0)+			;\
			subq.l %1,d1			;\
			bne *-10			;\
			/* Load in d2 number of operations left */  \
			and.l %3,d2			;\
			beq *+8				;\
			/* Perform last operations as SUM */  \
			add.l d0,(a0)+			;\
			subq.l %1,d2			;\
			bne *-4				;\
			/* Restore registers */  \
			movem.l (a7),d0-d2/a0		;\
			lea 60(a7),a7	    		;\
			};				\
		} while (0)

#endif // __ARR1D_ADDSC_H