/*
 * File:	mcf52233.h
 * Purpose:	Register and bit definitions for the MCF52233
 *
 * Notes:	
 *	
 */

#ifndef __MCF52233_H__
#define __MCF52233_H__

/********************************************************************/
/*
 * freescale fec driver includes
 */

#include "mii.h"
#include "nbuf.h"
#include "nif.h"
#include "fec.h"
#include "eth.h"
#include "eth_stub.h"


/********************************************************************/
/*
 * 52233 includes
 */

#include "mcf52233_scm.h"
#include "mcf52233_pmm.h"
#include "mcf52233_dma.h"
#include "mcf52233_uart.h"
#include "mcf52233_i2c.h"
#include "mcf52233_qspi.h"
#include "mcf52233_rtc.h"
#include "mcf52233_dtim.h"
#include "mcf52233_intc.h"
#include "mcf52233_intc_iack.h"
#include "mcf52233_fec.h"
#include "mcf52233_gpio.h"
#include "mcf52233_cim.h"
#include "mcf52233_clock.h"
#include "mcf52233_eport.h"
#include "mcf52233_pit.h"
#include "mcf52233_adc.h"
#include "mcf52233_pwm.h"
#include "mcf52233_can.h"
#include "mcf52233_cfm.h"
#include "mcf52233_rng.h"
#include "mcf52233_phy.h"

/********************************************************************/
/*
 * function prototypes
 */

void 
PIT_Timer_Init(uint8 PCSR, uint16 PMR);

void 
cpu_pause(int usecs);



#endif /* __MCF52233_H__ */
