/*
 * File:    mcf52233_phy.h
 * Purpose: Register and bit definitions
 */

#ifndef __MCF52233_PHY_H__
#define __MCF52233_PHY_H__

/*********************************************************************
*
* Ethernet PHY (PHY)
*
*********************************************************************/

/* Register read/write macros */
#define MCF_PHY_EPHYCTL0             (*(vuint8 *)(&__IPSBAR[0x1E0000]))
#define MCF_PHY_EPHYCTL1             (*(vuint8 *)(&__IPSBAR[0x1E0001]))
#define MCF_PHY_EPHYSR               (*(vuint8 *)(&__IPSBAR[0x1E0002]))

/* Bit definitions and macros for MCF_PHY_EPHYCTL0 */
#define MCF_PHY_EPHYCTL0_EPHYIEN     (0x01)
#define MCF_PHY_EPHYCTL0_EPHYWAI     (0x04)
#define MCF_PHY_EPHYCTL0_LEDEN       (0x08)
#define MCF_PHY_EPHYCTL0_DIS10       (0x10)
#define MCF_PHY_EPHYCTL0_DIS100      (0x20)
#define MCF_PHY_EPHYCTL0_ANDIS       (0x40)
#define MCF_PHY_EPHYCTL0_EPHYEN      (0x80)

/* Bit definitions and macros for MCF_PHY_EPHYCTL1 */
#define MCF_PHY_EPHYCTL1_PHYADDR(x)  (((x)&0x1F)<<0)

/* Bit definitions and macros for MCF_PHY_EPHYSR */
#define MCF_PHY_EPHYSR_EPHYIF        (0x01)
#define MCF_PHY_EPHYSR_10DIS         (0x10)
#define MCF_PHY_EPHYSR_100DIS        (0x20)

/********************************************************************/

#endif /* __MCF52233_PHY_H__ */
