/*
 * File:    mcf52233_intc_iack.h
 * Purpose: Register and bit definitions
 */

#ifndef __MCF52233_INTC_IACK_H__
#define __MCF52233_INTC_IACK_H__

/*********************************************************************
*
* Interrupt Controller (INTC_IACK)
*
*********************************************************************/

/* Register read/write macros */
#define MCF_INTC_IACK_GSWIACK            (*(vuint8 *)(&__IPSBAR[0x000FE0]))
#define MCF_INTC_IACK_GL1IACK            (*(vuint8 *)(&__IPSBAR[0x000FE4]))
#define MCF_INTC_IACK_GL2IACK            (*(vuint8 *)(&__IPSBAR[0x000FE8]))
#define MCF_INTC_IACK_GL3IACK            (*(vuint8 *)(&__IPSBAR[0x000FEC]))
#define MCF_INTC_IACK_GL4IACK            (*(vuint8 *)(&__IPSBAR[0x000FF0]))
#define MCF_INTC_IACK_GL5IACK            (*(vuint8 *)(&__IPSBAR[0x000FF4]))
#define MCF_INTC_IACK_GL6IACK            (*(vuint8 *)(&__IPSBAR[0x000FF8]))
#define MCF_INTC_IACK_GL7IACK            (*(vuint8 *)(&__IPSBAR[0x000FFC]))
#define MCF_INTC_IACK_GLIACK(x)          (*(vuint8 *)(&__IPSBAR[0x000FE4+((x-1)*0x004)]))

/* Bit definitions and macros for MCF_INTC_IACK_GSWIACK */
#define MCF_INTC_IACK_GSWIACK_VECTOR(x)  (((x)&0xFF)<<0)

/* Bit definitions and macros for MCF_INTC_IACK_GLIACK */
#define MCF_INTC_IACK_GLIACK_VECTOR(x)   (((x)&0xFF)<<0)

/********************************************************************/

#endif /* __MCF52233_INTC_IACK_H__ */
