/*
 * File:	mcf52233_gpt.h
 * Purpose:	Register and bit definitions for the MCF52233
 *
 * Notes:	
 *	
 */

#ifndef __MCF52233_GPT_H__
#define __MCF52233_GPT_H__

/*********************************************************************
*
* General Purpose Timer Module (GPT)
*
*********************************************************************/

/* Register read/write macros */
#define MCF_GPT_GPTIOS                     (*(vuint8 *)(&__IPSBAR[0x1A0000]))
#define MCF_GPT_GPTCFORC                   (*(vuint8 *)(&__IPSBAR[0x1A0001]))
#define MCF_GPT_GPTOC3M                    (*(vuint8 *)(&__IPSBAR[0x1A0002]))
#define MCF_GPT_GPTOC3D                    (*(vuint8 *)(&__IPSBAR[0x1A0003]))
#define MCF_GPT_GPTCNT                     (*(vuint16*)(&__IPSBAR[0x1A0004]))
#define MCF_GPT_GPTSCR1                    (*(vuint8 *)(&__IPSBAR[0x1A0006]))
#define MCF_GPT_GPTTOV                     (*(vuint8 *)(&__IPSBAR[0x1A0008]))
#define MCF_GPT_GPTCTl1                    (*(vuint8 *)(&__IPSBAR[0x1A0009]))
#define MCF_GPT_GPTCTL2                    (*(vuint8 *)(&__IPSBAR[0x1A000B]))
#define MCF_GPT_GPTIE                      (*(vuint8 *)(&__IPSBAR[0x1A000C]))
#define MCF_GPT_GPTSCR2                    (*(vuint8 *)(&__IPSBAR[0x1A000D]))
#define MCF_GPT_GPTFLG1                    (*(vuint8 *)(&__IPSBAR[0x1A000E]))
#define MCF_GPT_GPTFLG2                    (*(vuint8 *)(&__IPSBAR[0x1A000F]))
#define MCF_GPT_GPTC0                      (*(vuint16*)(&__IPSBAR[0x1A0010]))
#define MCF_GPT_GPTC1                      (*(vuint16*)(&__IPSBAR[0x1A0012]))
#define MCF_GPT_GPTC2                      (*(vuint16*)(&__IPSBAR[0x1A0014]))
#define MCF_GPT_GPTC3                      (*(vuint16*)(&__IPSBAR[0x1A0016]))
#define MCF_GPT_GPTPACTL                   (*(vuint8 *)(&__IPSBAR[0x1A0018]))
#define MCF_GPT_GPTPAFLG                   (*(vuint8 *)(&__IPSBAR[0x1A0019]))
#define MCF_GPT_GPTPACNT                   (*(vuint16*)(&__IPSBAR[0x1A001A]))
#define MCF_GPT_GPTPORT                    (*(vuint8 *)(&__IPSBAR[0x1A001D]))
#define MCF_GPT_GPTDDR                     (*(vuint8 *)(&__IPSBAR[0x1A001E]))

/* Bit definitions and macros for MCF_GPT_GPTIOS */
#define MCF_GPT_GPTIOS_IOS(x)                                 (((x)&0x0F)<<0)

/* Bit definitions and macros for MCF_GPT_GPTCFORC */
#define MCF_GPT_GPTCFORC_FOC(x)                               (((x)&0x0F)<<0)

/* Bit definitions and macros for MCF_GPT_GPTOC3M */
#define MCF_GPT_GPTOC3M_OC3M(x)                               (((x)&0x0F)<<0)

/* Bit definitions and macros for MCF_GPT_GPTOC3D */
#define MCF_GPT_GPTOC3D_OC3D(x)                               (((x)&0x0F)<<0)

/* Bit definitions and macros for MCF_GPT_GPTCNT */
#define MCF_GPT_GPTCNT_CNTR(x)                                (((x)&0xFFFF)<<0)

/* Bit definitions and macros for MCF_GPT_GPTSCR1 */
#define MCF_GPT_GPTSCR1_TFFCA                                 (0x10)
#define MCF_GPT_GPTSCR1_GPTEN                                 (0x80)

/* Bit definitions and macros for MCF_GPT_GPTTOV */
#define MCF_GPT_GPTTOV_TOV(x)                                 (((x)&0x0F)<<0)

/* Bit definitions and macros for MCF_GPT_GPTCTl1 */
#define MCF_GPT_GPTCTl1_OL0                                   (0x01)
#define MCF_GPT_GPTCTl1_OM0                                   (0x02)
#define MCF_GPT_GPTCTl1_OL1                                   (0x04)
#define MCF_GPT_GPTCTl1_OM1                                   (0x08)
#define MCF_GPT_GPTCTl1_OL2                                   (0x10)
#define MCF_GPT_GPTCTl1_OM2                                   (0x20)
#define MCF_GPT_GPTCTl1_OL3                                   (0x40)
#define MCF_GPT_GPTCTl1_OM3                                   (0x80)

/* Bit definitions and macros for MCF_GPT_GPTCTL2 */
#define MCF_GPT_GPTCTL2_EDG0A                                 (0x01)
#define MCF_GPT_GPTCTL2_EDG0B                                 (0x02)
#define MCF_GPT_GPTCTL2_EDG1A                                 (0x04)
#define MCF_GPT_GPTCTL2_EDG1B                                 (0x08)
#define MCF_GPT_GPTCTL2_EDG2A                                 (0x10)
#define MCF_GPT_GPTCTL2_EDG2B                                 (0x20)
#define MCF_GPT_GPTCTL2_EDG3A                                 (0x40)
#define MCF_GPT_GPTCTL2_EDG3B                                 (0x80)

/* Bit definitions and macros for MCF_GPT_GPTIE */
#define MCF_GPT_GPTIE_CI(x)                                   (((x)&0x0F)<<0)

/* Bit definitions and macros for MCF_GPT_GPTSCR2 */
#define MCF_GPT_GPTSCR2_PR(x)                                 (((x)&0x07)<<0)
#define MCF_GPT_GPTSCR2_TCRE                                  (0x08)
#define MCF_GPT_GPTSCR2_RDPT                                  (0x10)
#define MCF_GPT_GPTSCR2_PUPT                                  (0x20)
#define MCF_GPT_GPTSCR2_TOI                                   (0x80)

/* Bit definitions and macros for MCF_GPT_GPTFLG1 */
#define MCF_GPT_GPTFLG1_CF(x)                                 (((x)&0x0F)<<0)

/* Bit definitions and macros for MCF_GPT_GPTFLG2 */
#define MCF_GPT_GPTFLG2_CF(x)                                 (((x)&0x0F)<<0)
#define MCF_GPT_GPTFLG2_TOF                                   (0x80)

/* Bit definitions and macros for MCF_GPT_GPTC0 */
#define MCF_GPT_GPTC0_CCNT(x)                                 (((x)&0xFFFF)<<0)

/* Bit definitions and macros for MCF_GPT_GPTC1 */
#define MCF_GPT_GPTC1_CCNT(x)                                 (((x)&0xFFFF)<<0)

/* Bit definitions and macros for MCF_GPT_GPTC2 */
#define MCF_GPT_GPTC2_CCNT(x)                                 (((x)&0xFFFF)<<0)

/* Bit definitions and macros for MCF_GPT_GPTC3 */
#define MCF_GPT_GPTC3_CCNT(x)                                 (((x)&0xFFFF)<<0)

/* Bit definitions and macros for MCF_GPT_GPTPACTL */
#define MCF_GPT_GPTPACTL_PAI                                  (0x01)
#define MCF_GPT_GPTPACTL_PAOVI                                (0x02)
#define MCF_GPT_GPTPACTL_CLK(x)                               (((x)&0x03)<<2)
#define MCF_GPT_GPTPACTL_PEDGE                                (0x10)
#define MCF_GPT_GPTPACTL_PAMOD                                (0x20)
#define MCF_GPT_GPTPACTL_PAE                                  (0x40)

/* Bit definitions and macros for MCF_GPT_GPTPAFLG */
#define MCF_GPT_GPTPAFLG_PAIF                                 (0x01)
#define MCF_GPT_GPTPAFLG_PAOVF                                (0x02)

/* Bit definitions and macros for MCF_GPT_GPTPACNT */
#define MCF_GPT_GPTPACNT_PACNT(x)                             (((x)&0xFFFF)<<0)

/* Bit definitions and macros for MCF_GPT_GPTPORT */
#define MCF_GPT_GPTPORT_PORTT(x)                              (((x)&0x0F)<<0)

/* Bit definitions and macros for MCF_GPT_GPTDDR */
#define MCF_GPT_GPTDDR_DDRT(x)                                (((x)&0x0F)<<0)

/********************************************************************/

#endif /* __MCF52233_GPT_H__ */
