/*
 * File:        uart.c
 * Purpose:     Provide common ColdFire UART routines for serial IO
 *
 * Notes:       
 *              
 */
#pragma cplusplus off
#include "common.h"
#include "uart.h"
#include "m52233DEMO.h"

/********************************************************************/
/*
 * Wait for a character to be received on the specified UART
 *
 * Return Values:
 *  the received character
 */
char
uart_getchar (int channel)
{
    /* Wait until character has been received */
    while (!(MCF_UART_USR(channel) & MCF_UART_USR_RXRDY))
        ; 
    return MCF_UART_URB(channel);
}
/********************************************************************/
/*
 * Wait for space in the UART Tx FIFO and then send a character
 */ 
void
uart_putchar (int channel, char ch)
{
    /* Wait until space is available in the FIFO */
    while (!(MCF_UART_USR(channel) & MCF_UART_USR_TXRDY))
        ;
    /* Send the character */
    MCF_UART_UTB(channel) = (uint8)ch;
}
/********************************************************************/
/*
 * Check to see if a character has been received
 *
 * Return values:
 *  0       No character received
 *  1       Character has been received
 */
int
uart_getchar_present (int channel)
{
    return (MCF_UART_USR(channel) & MCF_UART_USR_RXRDY);
}
/********************************************************************/
    
