/*
 * File:		mcf52233.c
 * Purpose:		Source to select CF derivative
 *
 * Notes:
 */
/********************************************************************/
#pragma cplusplus off
#include "common.h"
/********************************************************************/
/*
 * Setup PIT Timer
 */
void PIT_Timer_Init(uint8 PCSR, uint16 PMR){

	/* Set tic for timers	*/

	MCF_PIT0_PCSR  = (uint16)(MCF_PIT_PCSR_PRE(PCSR));	/* Divide system clock/2 by 2^PCSR	*/
	MCF_INTC0_ICR55 = MCF_INTC_ICR_IL(TIMER_NETWORK_LEVEL);
	MCF_INTC0_IMRH &= ~MCF_INTC_IMRH_MASK55;
	MCF_PIT0_PMR = PMR;						/* modulo count	*/
	MCF_PIT0_PCSR |= MCF_PIT_PCSR_OVW | MCF_PIT_PCSR_PIE |
	                 MCF_PIT_PCSR_PIF | MCF_PIT_PCSR_RLD |
	                 MCF_PIT_PCSR_EN;
}

/********************************************************************/
/*
 * Pause for the specified number of micro-seconds.
 * Uses DTIM3 as a timer
 */
void
cpu_pause(int usecs)
{
    /* Enable the DMA Timer 3 */
    MCF_DTIM3_DTRR = (vuint32)(usecs - 1);
    MCF_DTIM3_DTER = MCF_DTIM_DTER_REF;
    MCF_DTIM3_DTMR = 0
        | MCF_DTIM_DTMR_PS(SYSTEM_CLOCK)
        | MCF_DTIM_DTMR_ORRI
        | MCF_DTIM_DTMR_FRR
        | MCF_DTIM_DTMR_CLK_DIV1
        | MCF_DTIM_DTMR_RST;

    while ((MCF_DTIM3_DTER & MCF_DTIM_DTER_REF) == 0) 
    {};
    
    /* Disable the timer */
    MCF_DTIM3_DTMR = 0;
}

/********************************************************************/
void
board_handle_interrupt (int vector)
{
    switch (vector)
    {
        case 68: /* Eport Interrupt 4 */
            printf("SW1\n");
            MCF_EPORT_EPFR1 = (uint8)(0x01 << 4);
            break;
        case 69: /* Eport Interrupt 5 */
            printf("SW2\n");
            MCF_EPORT_EPFR1 = (uint8)(0x01 << 5);
            break;
        case 71: /* Eport Interrupt 7 */
            printf("ABORT\n");
            MCF_EPORT_EPFR1 = (uint8)(0x01 << 7);
            break;
        case 65: /* Eport Interrupt 1 */
        case 66: /* Eport Interrupt 2 */
        case 67: /* Eport Interrupt 3 */
        case 70: /* Eport Interrupt 6 */
        default:
            MCF_EPORT_EPFR1 = (uint8)(0x01 << (vector - 64));
            printf("Edge Port Interrupt #%d\n",vector - 64);
            break;
    }
}
/********************************************************************/

/********************************************************************/
void
cpu_handle_interrupt (int vector)
{
    if (vector < 64 || vector > 192)
        return;
    
    if (vector >= 64 && vector <= 71)
        board_handle_interrupt(vector);
    else
        printf("User Defined Vector #%d\n",vector);
}
/********************************************************************/

