/* Services performed by FREESCALE in this matter are performed AS IS 
 * and without any warranty.  CUSTOMER  retains the final decision 
 * relative to the total design and functionality of the end product. 
 * FREESCALE neither guarantees nor will be held liable by CUSTOMER for 
 * the success of this project. FREESCALE disclaims all warranties, 
 * express, implied or statutory including, but not limited to, implied 
 * warranty of merchantability or fitness for a particular purpose on any 
 * hardware, software ore advise supplied  to the project by FREESCALE, 
 * and or any product resulting from FREESCALE services . In no event shall 
 * FREESCALE be liable for incidental or consequential damages arising out 
 * of this agreement. CUSTOMER agrees to hold FREESCALE harmless against any 
 * and all claims demands or actions by anyone on account of any damage, or 
 * injury, whether commercial, contractual, or tortuous, rising directly or 
 * indirectly as a result of the advise or assistance supplied CUSTOMER in 
 * connection with product, services or goods supplied under this Agreement. 
 **/

/**
  \mainpage 
  
  \n Copyright (c) 2005 Freescale Semiconductor
  \n Freescale Confidential Proprietary
  
  \brief 
  
  \author   	Freescale Semiconductor
  \author
  \author   	Guadalajara Applications Laboratory RTAC Americas
  
  \version		v.1.0
  \date			12/22/2005
  
  Use of FIR filters DSP functions in ColdFire.
  
*/

#include <stdio.h>
/** Header of FIR DSP functions */
#include "fir.h"

/** Number of samples */
#define N 1024

/** Maximum number of coefficients */
#define CoefN 507

/** Comment it if you don't want the 32 bits FIR filter */
#define bits32
/** Comment it if you don't want the 16 bits FIR filter */
//#define bits16

/** Global variable with the coefficients in float format */
float gfCoef[CoefN] = 
{
	#include "FIR_BandPass_Equiripple_48K_800-1300_Ord506.h"
};

/** Global variable with the input in float format */
float gfInput[N] =
{
	#include "sine_input.h"
};

#ifdef bits32

/** Global structure with the information of coefficients for the 32 bits FIR function */
struct tFir32Struct*  gsCoef32;

/** Global array with coefficients in Frac32 format */
Frac32 gaCoef32[N] = {0};

/** Global array with the input in Frac32 format */
Frac32 gaInput32[N] = {0};

/** Global array with the output filter in Frac32 format */
Frac32 gaOutput32[N] = {0};

#endif //bits32

#ifdef bits16

/** Global structure with the information of coefficients for the 16 bits FIR function */
struct tFir16Struct* gsCoef16;

/** Global array with coefficients in Frac16 format */
Frac16 gaCoef16[N] = {0};

/** Global array with the input in Frac16 format */
Frac16 gaInput16[N] = {0};

/** Global array with the output filter in Frac16 format */
Frac16 gaOutput16[N] = {0};

#endif //bits16


int main()
{
	uint32 i;

	#ifdef __EMAC
		printf("\n\r\n\r\n\rFIR test in eMAC\n\r");
	#else
		printf("\n\r\n\r\n\rFIR test in MAC\n\r");
	#endif
		

	#ifdef bits32    /* FIR 32 bits */

	printf("Input signal 32 bits \n\r\n\r");
	
	for(i = 0; i < N; i++)
	{
		gaInput32[i] = FRAC32(gfInput[i]);
		printf("%d \n\r",gaInput32[i]);
	}

	printf("\n\rCoefficients 32 bits \n\r\n\r");
	
	for(i = 0; i < CoefN; i++)
	{
		gaCoef32[i] = FRAC32(gfCoef[i]);
		printf("%d \n\r",gaCoef32[i]);
	}

	gsCoef32 = FIR32Create( gaCoef32, CoefN);

	FIR32(gsCoef32, gaInput32, gaOutput32, N);
	
	printf("\n\rOutput FIR signal 32 bits \n\r\n\r");

	for(i = 0; i < N; i++)
	{
		printf("%d\n\r",gaOutput32[i]);
	}
	
	FIR32Destroy(gsCoef32);
	
	#endif  /*bits32*/
	
	#ifdef bits16    /* FIR 16 bits */

	printf("\n\r\n\rInput signal 16 bits \n\r\n\r");
	
	for(i = 0; i < N; i++)
	{
		gaInput16[i] = FRAC16(gfInput[i]);
		printf("%d \n\r",gaInput16[i]);
	}

	printf("\n\rCoefficients 16 bits \n\r\n\r");
	
	for(i = 0; i < CoefN; i++)
	{
		gaCoef16[i] = FRAC16(gfCoef[i]);
		printf("%d \n\r",gaCoef16[i]);
	}

	gsCoef16 = FIR16Create( gaCoef16, CoefN);

	FIR16(gsCoef16, gaInput16, gaOutput16, N);
	
	printf("\n\rOutput FIR signal 16 bits \n\r\n\r");

	for(i = 0; i < N; i++)
	{
		printf("%d\n\r",gaOutput16[i]);
	}
	
	FIR16Destroy(gsCoef16);
	
	printf("\n\rEnd.\n\r");
	
	#endif /*bits16*/		
	
	while(1);	// Idle
	
	return 0;
	
}