/*
 * File:		mcf52233DEMO.c
 * Purpose:		Source to EVB specific routines
 *
 * Notes:   
 */
/********************************************************************/
#include "common.h"


/********************************************************************/
/*
 * Setup LED on the EVB
 */
void
Leds_Init(void){
//user LEDs
    /* Enable signals as GPIO */
    MCF_GPIO_PTCPAR = 0
        | MCF_GPIO_PTCPAR_TIN3_GPIO
        | MCF_GPIO_PTCPAR_TIN2_GPIO
        | MCF_GPIO_PTCPAR_TIN1_GPIO
        | MCF_GPIO_PTCPAR_TIN0_GPIO;
    
    /* Enable signals as digital outputs */
    MCF_GPIO_DDRTC = 0
        | MCF_GPIO_DDRTC_DDRTC3
        | MCF_GPIO_DDRTC_DDRTC2
        | MCF_GPIO_DDRTC_DDRTC1
        | MCF_GPIO_DDRTC_DDRTC0;

	MCF_GPIO_PORTTC = 0x00; // TURN LEDS OFF

// Ethernet status LEDs - This is only for rev0 Si.	
	if ((MCF_CIM_CIR & 0x003F)==0)
	{
		MCF_GPIO_PLDPAR = (0
						| MCF_GPIO_PORTLD_PORTLD1 // LNKLED
						| MCF_GPIO_PORTLD_PORTLD2 // SPDLED
						| MCF_GPIO_PORTLD_PORTLD3 // DUPLED
						| MCF_GPIO_PORTLD_PORTLD4 // COLLED
						);

		MCF_GPIO_DDRLD =  MCF_GPIO_DDRLD_DDRLD0 // ACTLED
						| MCF_GPIO_DDRLD_DDRLD5 // RXLED
						| MCF_GPIO_DDRLD_DDRLD6 // TXLED
						;
	}
    }

/********************************************************************/
/* 
 * Display the lower 4 bits of 'number' on the 4 LEDs connected to 
 * TIN[3:0]
 *
 *  LED: LED4 LED3 LED2 LED1
 *  PIN: TIN3 TIN2 TIN1 TIN0
 *  BIT:    3    2    1    0
 */
void
board_led_display(uint8 number)
{
    /* Set output values */
    MCF_GPIO_PORTTC = number;
}
/********************************************************************/
