/*
 * File:		nif.h
 * Purpose:		Definition of a Network InterFace.
 *
 * Notes:
 *
 * Author:		Eric DeVolder
 * Date:		11-8-95
 *
 * Modifications:
 *
 */

#ifndef _NIF_H
#define _NIF_H

/********************************************************************/
/* Include Ethernet standards definitions and network buffer specifics */

#include "eth.h"
#include "nbuf.h"

/********************************************************************/

extern uint8 TIMER_NETWORK;

/* Maximum number of supported protoocls: IP, ARP, RARP */
#define MAX_SUP_PROTO   (3)

typedef struct
{
	uint16	protocol;
	void	(*handler)(void*);
	void	*info;	/* pointer to protocol defined config info */
} SUP_PROTO;

typedef
uint8	HWA_ADDR_P[];

typedef struct NIF_t
{
	char		name[16];
	ETH_ADDR	hwa;	/* ethernet card hardware address */
	ETH_ADDR	broadcast;	/* ethernet broadcast address */
	int			hwa_size;
	int			mtu;	/* hardware maximum transmission unit */

	SUP_PROTO	protocol[MAX_SUP_PROTO];
	unsigned short	num_protocol;

	int		(*reset)(struct NIF_t *);
	void	(*start)(struct NIF_t *);
	void	(*stop)(struct NIF_t *);
	int		(*send)(struct NIF_t *, NBUF *);
	void	(*receive)(struct NIF_t *);
	NBUF*	(*rx_alloc)(void);
	NBUF*	(*tx_alloc)(void);
	void	(*rx_free)(NBUF *);
	void	(*tx_free)(NBUF *);

	void	*nic;	/* base address of NIC chipset */
	int		vector;	/* vector used by device */
	unsigned int	next_receive;	/* needed by the SEEQ */

	unsigned int	f_rx;
	unsigned int	f_tx;
	unsigned int	f_rx_err;
	unsigned int	f_tx_err;
	unsigned int	f_err;
} NIF;


/********************************************************************/

NIF *
nif_init (NIF *, char *);

int
nif_protocol_exist (NIF *, uint16);

void
nif_protocol_handler (NIF *);

void *
nif_get_protocol_info (NIF *, uint16);

int
nif_bind_protocol (NIF *, uint16, void *, void *);

/********************************************************************/

#endif /* _NIF_H */
