/*
 * File:		nif.c
 * Purpose:		Network InterFace routines
 *
 * Notes:
 *
 * Modifications:
 *
 */

#include "common.h"
//#include "src/common/stdlib.h"
//#include "nif.h"

/********************************************************************/
int
nif_protocol_exist (NIF *nif, uint16 protocol)
{
	/*
	 * This function searches the list of supported protocols
	 * on the particular NIF and if a protocol handler exists,
	 * TRUE is returned.  This function is useful for network cards
	 * that needn't read in the entire frame but can discard frames
	 * arbitrarily.
	 */
	int index;

	return TRUE;

	for (index = 0; index < nif->num_protocol; ++index)
	{
		if (nif->protocol[index].protocol == protocol)
		{
			return TRUE;
		}
	}
	return FALSE;
}

/********************************************************************/
void
nif_protocol_handler (NIF *nif)
{
	/*
	 * This function searches the list of supported protocols
	 * on the particular NIF and if a protocol handler exists,
	 * the protocol handler is invoked.  This routine called by
	 * network device driver after receiving a frame.
	 */

	nif->protocol[0].handler(nif);
	

}

/********************************************************************/
void *
nif_get_protocol_info (NIF *nif, uint16 protocol)
{
	/*
	 * This function searches the list of supported protocols
	 * on the particular NIF and returns a pointer to the
	 * config info for 'protocol', otherwise NULL is returned.
	 */
	int index;

	for (index = 0; index < nif->num_protocol; ++index)
	{
		if (nif->protocol[index].protocol == protocol)
			return (void *)nif->protocol[index].info;
	}
	return (void *)0;
}

/********************************************************************/
int
nif_bind_protocol (NIF *nif, uint16 protocol, void *handler, void *info)
{
	/*
	 * This function registers 'protocol' as a supported
	 * protocol in 'nif'.
	 */
	if (nif->num_protocol < (MAX_SUP_PROTO - 1))
	{
		nif->protocol[nif->num_protocol].protocol = protocol;
		nif->protocol[nif->num_protocol].handler = handler;
		nif->protocol[nif->num_protocol].info = info;
		++nif->num_protocol;
		return TRUE;
	}
	return FALSE;
}

/********************************************************************/
NIF *
nif_init (NIF *nif, char *name)
{
	int i;

	strncpy(nif->name,name,16);

	for (i = 0; i < sizeof(ETH_ADDR); i++)
	{
		nif->hwa[i] = 0;
		nif->broadcast[i] = 0xFF;
	}
	nif->hwa_size = 6;

	for (i = 0; i < MAX_SUP_PROTO; ++i)
	{
		nif->protocol[i].protocol = 0;
		nif->protocol[i].handler = 0;
		nif->protocol[i].info = 0;
	}
	nif->num_protocol = 0;

	nif->mtu = 0;
	nif->reset = 0;
	nif->start = 0;
	nif->stop = 0;
	nif->send = 0;
	nif->receive = 0;

	nif->nic = 0;
	nif->vector = 0;

	nif->f_rx = 0;
	nif->f_tx = 0;
	nif->f_rx_err = 0;
	nif->f_tx_err = 0;
	nif->f_err = 0;

	nif->rx_alloc = 0;
	nif->tx_alloc = 0;
	nif->rx_free = 0;
	nif->tx_free = 0;

	return nif;
}

/********************************************************************/
