/*
 * File:		eth.h
 * Purpose:		Definitions for Ethernet Frames.
 *
 * Modifications:
 */

#ifndef _ETH_H
#define _ETH_H

/*******************************************************************/

/* 48-bit Ethernet Addresses */
typedef uint8 ETH_ADDR[6];

/* 16-bit Ethernet Frame Type, ie. Protocol */
typedef uint16 ETH_FTYPE;

/* Defined Ethernet Frame Types */
#define FRAME_IP	(0x0800)
#define FRAME_ARP	(0x0806)
#define FRAME_RARP	(0x8035)

/* Maximum and Minimum Ethernet Frame Size (Data Field) */
#define ETH_MAX_SIZE	(1500)
#define ETH_MIN_SIZE	(46)

/* Ethernet Frame definition */
typedef struct
{
	ETH_ADDR dest;
	ETH_ADDR src;
	ETH_FTYPE type;
	uint8 data[ETH_MAX_SIZE];
} eth_frame_hdr;

/* Offset and size of protocol headers */
#define ETH_HDR_OFFSET	0	/* ethernet header at the top of the frame */
#define ETH_HDR_SIZE	14

/*******************************************************************/

#endif 	/* _ETH_H */
