/*
 * File:		Int_handlers.c
 * Purpose:		contains all intrrupt processes
 *
 * IMPORTANT. Read the following Freescale Semiconductor Software License 
 * Agreement:
 * http://www.freescale.com/files/disclaimer/LA_OPT1.html
 * 
 */

#include "common.h"
#include "Int_handlers.h"

NIF	fec_nif;
unsigned char SINE;
unsigned short	SineCnt;
const unsigned char SineTable[360] =
{
	255,254,254,254,254,254,254,254,253,253,253,252,252,251,251,250,
	250,249,248,248,247,246,245,244,244,243,242,241,240,239,237,236,
	235,234,233,232,230,229,228,226,225,223,222,220,219,217,216,214,
	212,211,209,207,206,204,202,200,199,197,195,193,191,189,187,185,
	183,181,179,177,175,173,171,169,167,165,163,160,158,156,154,152,
	150,147,145,143,141,139,136,134,132,130,128,125,123,121,119,116,
	114,112,110,108,105,103,101,99,97,95,92,90,88,86,84,82,80,78,76,
	74,72,70,68,66,64,62,60,58,56,55,53,51,49,48,46,44,43,41,39,38,
	36,35,33,32,30,29,27,26,25,23,22,21,20,19,18,16,15,14,13,12,11,
	11,10,9,8,7,7,6,5,5,4,4,3,3,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	2,2,2,3,3,4,4,5,5,6,7,7,8,9,10,11,11,12,13,14,15,16,18,19,20,21,
	22,23,25,26,27,29,30,32,33,35,36,38,39,41,43,44,46,48,49,51,53,
	55,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,95,
	97,99,101,103,105,108,110,112,114,116,119,121,123,125,127,130,
	132,134,136,139,141,143,145,147,150,152,154,156,158,160,163,165,
	167,169,171,173,175,177,179,181,183,185,187,189,191,193,195,197,
	199,200,202,204,206,207,209,211,212,214,216,217,219,220,222,223,
	225,226,228,229,230,232,233,234,235,236,237,239,240,241,242,243,
	244,244,245,246,247,248,248,249,250,250,251,251,252,252,253,253,
	253,254,254,254,254,254,254,254
};
/********************************************************************/
/* simple little timer OS below
/********************************************************************/

unsigned long rti_count = 0;
unsigned long run_count = 0;
unsigned char rti_tic_rate = 10;   // *10ms
unsigned int  rti_1st_mult = 10;   // 100ms
unsigned int  rti_2nd_mult = 20;   // 200ms
unsigned int  rti_3rd_mult = 30;   // 300ms
unsigned int  rti_4th_mult = 40;   // 400ms
unsigned int  rti_5th_mult = 50;   // 500ms
unsigned int  rti_6th_mult = 300; // 30 sec

/********************************************************************/

void abort_handler(void){}
void sw1_handler(void)  {}
void sw2_handler(void)  {}
void sw3_handler(void)  {}
void rti_1st_event()    {}
void rti_2nd_event()    {}
void rti_3rd_event()    {SineCnt++;
					     SINE = SineTable[SineCnt % 360];
						}
void rti_4th_event()    {}
void rti_5th_event()    {}
void rti_6th_event()    {fec_mii_blk_test();}

/********************************************************************/
__interrupt__
void timer_handler (void)
{
	MCF_PIT0_PMR |= MCF_PIT_PCSR_PIF;

    rti_count++;
    if( ((rti_count % rti_tic_rate) == 0))      
    {
      run_count++;

      // Channel 1 updates
      if(( run_count % rti_1st_mult ) == 0 )
        {rti_1st_event();}
      // Channel 2 updates
      if(( run_count % rti_2nd_mult ) == 0 )
      	{rti_2nd_event();}
      // Channel 3 updates
      if(( run_count % rti_3rd_mult ) == 0 )
      	{rti_3rd_event();}
      // Channel 4 updates
      if(( run_count % rti_4th_mult ) == 0 )
        {rti_4th_event();}
      // Channel 5 updates
      if(( run_count % rti_5th_mult ) == 0 )
        {rti_5th_event();}
      // Channel 6 updates
      if(( run_count % rti_6th_mult ) == 0 )
        {rti_6th_event();}
   }
}
/********************************************************************/
__interrupt__
void irq_handler (void)
{
	/*
	 * This is the catch all interrupt handler for all user defined
	 * interrupts.  To create specific handlers, create a new interrupt
	 * handler and change vectors.s to point to the new handler.
	 */
	printf("irq_handler\n");
}

/********************************************************************/
__interrupt__
void ethernet_handler (void)
{
	extern NIF fec_nif;
	printf("fec_handler\n");

	fec_handler(&fec_nif);
}
/********************************************************************/
__interrupt__
void ephy_handler (void)
{
	printf("ephy_handler\n");
}
/********************************************************************/
/*
 * irq1 Handler
 */
__interrupt__ void
irq1_handler(void)
{
	printf("\nirq one.   - ");
    /* Wait for the switch to deassert */
    while (!(MCF_EPORT_EPPDR0 & MCF_EPORT_EPPDR_EPPD1)) {};
	sw3_handler();
    /* Clear the interrupt event */
    MCF_EPORT_EPFR0 = (uint8)(MCF_EPORT_EPFR0 | MCF_EPORT_EPFR_EPF1);
	printf("\n");
}
/********************************************************************/
/*
 * irq4 Handler
 */
__interrupt__ void
irq4_handler(void)
{
	printf("\nirq four.  - ");
    /* Wait for the switch to deassert */
    while (!(MCF_EPORT_EPPDR0 & MCF_EPORT_EPPDR_EPPD4)) {};
	sw1_handler();
    /* Clear the interrupt event */
    MCF_EPORT_EPFR0 = (uint8)(MCF_EPORT_EPFR0 | MCF_EPORT_EPFR_EPF4);
	printf("\n");
}
/********************************************************************/
/*
 * irq7 Handler
 */
__interrupt__ void
irq7_handler(void)
{
	printf("\nirq seven. - ");
    /* Wait for the switch to deassert */
    while (!(MCF_EPORT_EPPDR0 & MCF_EPORT_EPPDR_EPPD7)) {};
	abort_handler();
    /* Clear the interrupt event */
    MCF_EPORT_EPFR0 = (uint8)(MCF_EPORT_EPFR0 | MCF_EPORT_EPFR_EPF7);
	printf("\n");
}
/********************************************************************/
/*
 * irq11 Handler
 */
__interrupt__ void
irq11_handler(void)
{
	printf("\nirq eleven.- ");
    /* Wait for the switch to deassert */
    while (!(MCF_EPORT_EPPDR1 & MCF_EPORT_EPPDR_EPPD11)) {};
	sw2_handler();
    /* Clear the interrupt event */
    MCF_EPORT_EPFR1 = (uint8)(MCF_EPORT_EPFR1 | MCF_EPORT_EPFR_EPF11);
	printf("\n");
}
/********************************************************************/
