/* FILENAME: main.c
 *
 * Copyright 2005 By InterNiche Technologies Inc. All rights reserved
 *
 *
 * PORTABLE: NO
 */

#include "ipport.h"        /* from Interniche directory */
#include "osport.h"

/* internal: */
#ifdef SUPERLOOP
void tk_yield(void);
#endif
void  kbdio(void);
void  dtrap();
int   packet_chk(void);

/* from linker file */
extern int  __heap_addr;
extern int  __heap_size;

extern   char *   prompt;
extern   int      TCPTV_MSL;          /* in ..\tcp\tcp_timr.h */
extern   u_char   mac_addr_fec[8];
extern   int      uart_yield;         /* in iuart.c */

extern   int   netmain_init(void);
extern   void  netmain(void);

extern	 void start_AD(void);
extern	 void init_adc (void);

extern   __declspec(interrupt) void fec_isr(void);
extern   __declspec(interrupt) void timer_isr(void);
extern u_long activehost;
extern struct net  netstatic[STATIC_NETS];   /* in ../ip/ipstart.c */

/* Note that we assume the boards clock is 60MHz. */
#define CTICKS_PER_SEC  200     /* This is our goal to achieve */
#define PIT1_INTS_PER_SEC 1000  /* that is a reasonable value */
#define INTS_PER_CTICK  (PIT1_INTS_PER_SEC / CTICKS_PER_SEC)

u_long   cticks = 0;
int   memtrapsize = 0;
int min_cnt = 0;

#ifdef IPSEC
#ifndef IKE
int prep_ipsec(void);
#endif
#endif

/********************************************************************/

int main (void)
{
	int      err;
	unsigned long   tmp;
	uint16 mymrdata, mymwdata;    								//temp variable for MII read/write data


   	mcf5xxx_irq_enable();           /* Let the interrupts fly... */

	LED_INIT();
	init_adc();
	start_AD();
	while( !uart_flush(0) ){};
	printf("\n\nRunning ColdFire TCP/IP-Lite stack\n");
	printf("\nCopyright 2006 by Freescale Semiconductor Inc.\n");
	printf("Use of this software is controlled by the agreement\n");
	printf("found in the project LICENSE.H file.\n");
	printf("Built on %s %s\n",__DATE__, __TIME__);
	while( !uart_flush(0) ){};

#ifdef SYS_SHUTDOWN
   	printf("\System shutdown in %d minutes\n", SYS_SHUTDOWN/60);
#endif

   /* The C lib already has a small heap in the program image (which
    * is why the printf already works) but we need more. So we
    * take what's left of the 16 megs on the card.
    */
   mheap_init((char *)&__heap_addr, (long)&__heap_size);  /* start, length */

#ifdef NPDEBUG
   printf("\nHeap size = %d bytes\n", (long)&__heap_size );
#endif

   port_prep = prep_evb;

   /* hardcode FEC IP address for now. We set it in netstatic, and
    * Ip startup code will initialize net[] from it.
    */
	if( !POWERUP_CONFIG_DHCP_ENABLED )
	{
   		// 192.168.1.99    
   		netstatic[0].n_ipaddr = (0xC0A80163); 
   		netstatic[0].snmask   = (0xfffffC00);
	}
   		netstatic[0].n_defgw  = (0xC0A80101);
   
   netstatic[0].mib.ifDescr = (u_char *)"Fast Ethernet Controller";

   /* We set the station's Ethernet physical (MAC) address
    * from the address already in use by dBUG. This prevents
    * ARP problems on the development server. Production systems
    * usually read this from flash or eprom.
    */

#ifdef USE_FEC
   tmp = 0x00badbad;
   mac_addr_fec[0] = (u_char)(tmp >> 24);
   mac_addr_fec[1] = (u_char)(tmp >> 16);
   mac_addr_fec[2] = (u_char)(tmp >> 8);
   mac_addr_fec[3] = (u_char)(tmp & 0xff);
   tmp = 0x01020304;
   mac_addr_fec[4] = (u_char)(tmp >> 24);
   mac_addr_fec[5] = (u_char)(tmp >> 16);
#ifdef NPDEBUG
   dprintf("etheraddr = %02X:%02X:%02X:%02X:%02X:%02X\n\n",
            mac_addr_fec[0], mac_addr_fec[1], mac_addr_fec[2],
            mac_addr_fec[3], mac_addr_fec[4], mac_addr_fec[5]);
#endif
#endif

	// EMG - Override default buffer sizes to fit into Kirin2E

   bigbufsiz = 1536 + 16;   // EMG
   lilbufsiz = 200;			// EMG

   /* Heap memory saving trick - reduce the time a TCP socket
    * will linger in CLOSE_WAIT state. For systems with limited
    * heap space and a busy web server, this makes a big difference.
    */
   // EMG was 5    4/5/06 set to 1
   TCPTV_MSL = 1;    /* set low max seg lifetime default */

#ifdef NPDEBUG
   printf("Starting ints.\n");
#endif

//   mcf5xxx_irq_enable();           /* Let the interrupts fly... */
   iniche_net_ready = TRUE;

	while( !uart_flush(0) ){};

#ifdef SUPERLOOP
   if (prep_modules())
   {
      printf("SUPERLOOP: prep_modules() failed\n");
   }
   err = netmain_init();     /* Start net functions */
   printf("netmain_init done; code %d.\nStarting ints.\n%s", err, prompt);
#ifdef IPSEC
#ifndef IKE
   if(prep_ipsec())
   {
      printf("prep_ipsec() failed!\n");
   }
#endif
#endif
   while(1)
   {
      tk_yield();
   }
#else
#ifdef NPDEBUG
   printf("Calling netmain()...\n");
#endif
   netmain();     /* Start and run net tasks, no return. */
   USE_ARG(err);
#endif   /* SUPERLOOP */

   return 0;
}

/* FUNCTION: dtrap()
 *
 * Trap fatal errors with dBUG
 *
 * PARAMS: none
 *
 * RETURNS: none
 *
 * Causes control to transfer to the dBUG monitor. 
 */

void
dtrap()
{
   printf("dtrap\n");
//   while(1);
}

/* FUNCTION: timer_isr()
 *
 * Clock interrupt handler
 *
 * PARAMS: none
 *
 * RETURNS: none
 *
 * Increments the following counters:
 *    timer_ticks = raw system clock ticks
 *    timerct = number of system clock ticks in a ctick
 *    cticks  = number of clock ticks
 *    pit_counter = timer_ticks; used by profiler
 */

static long    timer_ticks = 0;
static int     timerct = 0;
static unshort pit_counter = 0;
#ifdef SYS_SHUTDOWN
static int     sys_shutdown = SYS_SHUTDOWN*1000;
#endif

__declspec(interrupt) 
void
timer_isr()
{
   ++timer_ticks;

   if (++timerct >= INTS_PER_CTICK)
   {
      cticks++;
      timerct = 0;
   }
#ifdef USE_PROFILER
   /* count all PIT ints for the profiler value */
   pit_counter++;
#endif   /* USE_PROFILER */

#ifdef SYS_SHUTDOWN
/* TODO: may want to call netexit(15) from the main loop
 *       to shutdown more gracefully */
   if (timer_ticks >= sys_shutdown)
   {
      exit(15);
   }
#endif

   /* Clear interrupt at CSR */
   MCF_PIT_PCSR(0) |= MCF_PIT_PCSR_PIE;
}



/* FUNCTION: exit()
 *
 * Program exit
 *
 * PARAM1: code;     program exit code
 *
 * RETURNS: none
 */

void
exit(int code)
{
   printf("Exit, code %d. Push RESET button now.\n", code);
   mcf5xxx_irq_disable();
   while (1)
      asm { halt };
}


static int crits = 0;
static int sysint;

void
ENTER_CRIT_SECTION(void*p)
{
   if(crits++ == 0)
   {
      sysint = asm_set_ipl(7);
   }
}

void
EXIT_CRIT_SECTION(void * p)
{
   if(--crits == 0)
   {
      asm_set_ipl(sysint);
   }
   if(crits < 0)
   {
      printf("negative crit section ct(%d)\n", crits);
      dtrap();
   }
}

/* high-granularity tick return for InterNiche profiler. We use
 * the cticks PIT for this value. The low order 16 bits come 
 * from the fast derecmenting counter register, the high 16 bits
 * come from the interrupt counter.
 */

u_long
get_ptick(void)
{
   u_short low16;    /* low 16 bits of return value */

   /* invert current PIT countdown as low half */
   low16 = ~(MCF_PIT0_PCNTR);

   return (((u_long)pit_counter << 16) + (u_long)low16);
}

/********************************************************************/
/* 
/* 
/* 
/* 
/********************************************************************/
/********************************************************************/
/* user interface to select functions. */
/********************************************************************/
//jpw
	void abort_handler(void){}
	void sw1_handler(void)  {}
	void sw2_handler(void)  {}
	void sw3_handler(void)  {}
    void rti_1st_event()    {}
    void rti_2nd_event()    {}
    void rti_3rd_event()    {}
    void rti_4th_event()    {}
    void rti_5th_event()    {}
    void rti_6th_event()    {}
	


