//*****************************************************************************
// Copyright (c) 2006, Freescale Semiconductor
// Freescale Confidential Proprietary
// For use on Freescale products only.
//
// File name :   	freescale_http_server.h
// Project name: 	emg_HTTP web server for Coldfire
// Author:			Eric Gregori   (847) 651 - 1971
//		   			eric.gregori@freescale.com
//
// Description : 	HTTP/Web server with static anf dynamic FFS support.
//					Dynamic HTML is supported via tokens in the HTML.
//					A key is used to support run time ( dynamic ) web page uploads.
//					Without the correct key, the download is rejected.
//					The web server supports multiple sessions as defined by EMG_HTTP_SESSION.
//					The web server supports 'GET', 'POST','EMG'.
//					EMG is a unique non-standard HTTP command to request a upload.
//					Uploading is done using the same server that serves up the web pages.
//					Long filenames are supported, along with subdirectories.
//
//*****************************************************************************

//*****************************************************************************
// There are 6 levels of Verbose.
//
// Level 0 - Only fatal errors are output to the console.
// Level 1 - Future expansion
// Level 2 - File system
// Level 3 - Server + File system
// Level 4 - Server + File system + Internal variables
// Level 5 - All the above + Download progress ( slows things way down ).
// Level 6 - Dynamic HTML + all the above.
//*****************************************************************************
#define HTTP_VERBOSE						0


//*****************************************************************************
// HEADER TYPES
//*****************************************************************************
typedef enum 
{
											NO_HEADER_FOUND,
											TYPE_GET,
											TYPE_UPLOAD,
											TYPE_POST
} HEADER_TYPES;


//*****************************************************************************
// Session Structure
//*****************************************************************************
typedef struct
{
	int            			state;         	// state of the protocol.  
   	int         			valid;     		// Data in this entry is valid
   	unsigned long			keep_alive;		// Connection Persistance EMG 4/14/06
   	unsigned long			file_type;		// File Type
   	unsigned long			file_size;		// Overall File size in bytes
	unsigned long			file_index;		// Index for referencing data	
	HEADER_TYPES			headertype;		// Header type
   	void					*file_pointer;	// Pointer to start data - do not change
   	M_SOCK       			socket;        	// the open socket we are using  
} EMG_HTTP_SESSION;


//*****************************************************************************
// Forms Structure
//*****************************************************************************
typedef struct
{
	unsigned char			form_name[8];		// Name on form
	void 					(*func)(char *);  	// Function pointer	
} FORM_STRUCTURE;


//*****************************************************************************
// FLAGS - EMG 4/14/06
//*****************************************************************************
#define HTTP_KEEP_ALIVE_TIME				100	// 10 seconds


//*****************************************************************************
// Session Structure - valid
//*****************************************************************************
#define INVALID_EMG_SESSION					0
#define VALID_EMG_SESSION					1


//*****************************************************************************
// HTTP server port #, default to 80
//*****************************************************************************
#define PORT_NUMBER							80


//*****************************************************************************
// Receive buffer, DO NOT CHANGE!!!
//*****************************************************************************
#define RECV_BUFFER_SIZE					0x100
#define MAX_HEADER_READS					(1548/RECV_BUFFER_SIZE)


//*****************************************************************************
// MAX bytes to send in one packet
//*****************************************************************************
#define MAX_BYTES_TO_SEND					1400

//#define SUCCESS							0
#define EMG_HTTP_INIT_FAILED				1


//*****************************************************************************
// The EMG HTTP server supports multiple sessions.  This increases the download
// speed considerably.  
//*****************************************************************************
#define MAX_NUMBER_OF_SESSIONS				4

//*****************************************************************************
// Dynamic HTML settings
//*****************************************************************************
// max size of a dynamic HTML token string
#define MAX_DYNAMIC_STRING_SIZE				256

// max number of dynamic HTML variables
#define MAX_NUMBER_OF_VARS					32

// File types scanned for dynamic HTML content
#define FILE_TYPE_DYANMIC1					'html'
#define FILE_TYPE_DYANMIC2					'text'

// dynamic HTML ascii tokens
#define DYNAMIC_REPLACE_TOKEN				'~'
#define DYNAMIC_COMPARE_TOKEN				'^'
#define DYNAMIC_EOS_TOKEN					';'


//*****************************************************************************
// EMG HTTP states
//*****************************************************************************
enum
{
											EMG_HTTP_STATE_WAIT_FOR_HEADER,
											EMG_HTTP_STATE_SEND_FILE,
											EMG_HTTP_STATE_CLOSE,
											EMG_HTTP_STATE_ERASE_FLASH,
											EMG_HTTP_STATE_UPLOAD_FILE
};


//*****************************************************************************
// Max size of HTTP command, GET, POST, ...
//*****************************************************************************
#define HEADER_TYPE_SIZE					4

typedef struct
{
	unsigned char	header_string[HEADER_TYPE_SIZE+1];
	HEADER_TYPES	header_type;
} HEADER_STRUCTURE;


//*****************************************************************************
// FLASH Parameters
//*****************************************************************************
	extern char __DATA_ROM[];
	extern char __BSS_START[];
//	extern char __BSS_END[];

// Start address for region of flash available for web page upload
//jpw #define FLASH_START_ADDRESS					0x44020000
//	//End of code flash + one sector __DATA_END
#define FLASH_START_ADDRESS		\
(((vuint32)&__DATA_ROM[0x44000800]) +(((vuint32)&__BSS_START)& 0x00007FFF)& 0xFFFFF800)	

// End address for region of flash available for web page upload
#define FLASH_END_ADDRESS					0x4403FFFF

// Flash erase page size
#define FLASH_PAGE_SIZE						0x0800

// Number of flash pages erased per task itteration
#define PAGES_PER_SESSION					0x08

// Address for flash region as seen by CPU
//	//jpw #define FAT_FILE_BASE_ADDR					0x00020000
#define FAT_FILE_BASE_ADDR		\
(((vuint32)&__DATA_ROM[0x800]) +(((vuint32)&__BSS_START)& 0x00007FFF)& 0xFFFFF800)	
