/*
 * File:		Int_handlers.c
 * Purpose:		contains all intrrupt processes
 *
 * IMPORTANT. Read the following Freescale Semiconductor Software License 
 * Agreement:
 * http://www.freescale.com/files/disclaimer/LA_OPT1.html
 * 
 */

#include "common.h"
#include "Int_handlers.h"

uint8	ephy_isr;
/********************************************************************/
/* 
/* 
/* 
/* 
/********************************************************************/
/********************************************************************/
__interrupt__
void timer_handler (void)
{
	MCF_PIT0_PMR |= MCF_PIT_PCSR_PIF;
}
/********************************************************************/
__interrupt__
void irq_handler (void)
{
	/*
	 * This is the catch all interrupt handler for all user defined
	 * interrupts.  To create specific handlers, create a new interrupt
	 * handler and change vectors.s to point to the new handler.
	 */
	printf("irq_handler\n");
}

/********************************************************************/
__interrupt__
void ethernet_handler (void)
{
}
/********************************************************************/
//=======================================================================
///EPHY ISR - Type of EPHY interrupt determined by MII read of PHY_REG_IR register
//=======================================================================
__interrupt__
void ephy_handler (void)
{
#if 0
  uint16 mymrdata, isr_read, temp, temp2;
  
  printf( "\n\nePHY interrupt - " );
	
  //@@@@@@@@@@@@@@@@
  //STEP1: PHY interrupt flag clearing.	Read PHY_REG_IR to determine PHY intterrupt
  // Need to read MII Inter. register 22 before clearing  EPHYIF
  //@@@@@@@@@@@@@@@@
  while ( !(fec_mii_read(FEC_PHY0, PHY_REG_IR, &isr_read)) )
  {
  	
  };

  //@@@@@@@@@@@@@@@@
  //STEP2: Process PHY interrupt register 0x10 (PHY_REG_IR) contenets
  //handlers for different interrupts	 flags
  //@@@@@@@@@@@@@@@@

     while ( !(fec_mii_read(FEC_PHY0, PHY_REG_PSR, &mymrdata)) )
     {
     	
     };
		     if ((mymrdata & PHY_R17_SPD) == PHY_R17_SPD)  {
		         printf("100bT - ");
		     }
		     else		
		     {
		         printf("10bT - ");
		     }

		     if ((mymrdata & PHY_R17_DPM) == PHY_R17_DPM)  {
		         printf("Full Dup\n\n");
		     }
		     else		
		     {
		         printf("Half Dup\n\n");
		     }

		while ( !(fec_mii_read(FEC_PHY0, PHY_REG_IR, &mymrdata)) )
		{
			
		};
		printf( "\n\nHit Enter for Prompt\n\n" );		
#else		
		MCF_PHY_EPHYSR = (uint8)(MCF_PHY_EPHYSR_EPHYIF); 
		ephy_isr = 1;
#endif		
}


/********************************************************************/
/*
 * irq1 Handler
 */
__interrupt__ void
irq1_handler(void)
{
	printf("\nirq one.   - ");
    /* Wait for the switch to deassert */
    while (!(MCF_EPORT_EPPDR0 & MCF_EPORT_EPPDR_EPPD1)) {};
	sw3_handler();
    /* Clear the interrupt event */
    MCF_EPORT_EPFR0 = (uint8)(MCF_EPORT_EPFR0 | MCF_EPORT_EPFR_EPF1);
	printf("\n");
}
/********************************************************************/
/*
 * irq4 Handler
 */
__interrupt__ void
irq4_handler(void)
{
	printf("\nirq four.  - ");
    /* Wait for the switch to deassert */
    while (!(MCF_EPORT_EPPDR0 & MCF_EPORT_EPPDR_EPPD4)) {};
	sw1_handler();
    /* Clear the interrupt event */
    MCF_EPORT_EPFR0 = (uint8)(MCF_EPORT_EPFR0 | MCF_EPORT_EPFR_EPF4);
	printf("\n");
}
/********************************************************************/
/*
 * irq7 Handler
 */
__interrupt__ void
irq7_handler(void)
{
	printf("\nirq seven. - ");
    /* Wait for the switch to deassert */
    while (!(MCF_EPORT_EPPDR0 & MCF_EPORT_EPPDR_EPPD7)) {};
	abort_handler();
    /* Clear the interrupt event */
    MCF_EPORT_EPFR0 = (uint8)(MCF_EPORT_EPFR0 | MCF_EPORT_EPFR_EPF7);
	printf("\n");
}
/********************************************************************/
/*
 * irq11 Handler
 */
__interrupt__ void
irq11_handler(void)
{
	printf("\nirq eleven.- ");
    /* Wait for the switch to deassert */
    while (!(MCF_EPORT_EPPDR1 & MCF_EPORT_EPPDR_EPPD11)) {};
	sw2_handler();
    /* Clear the interrupt event */
    MCF_EPORT_EPFR1 = (uint8)(MCF_EPORT_EPFR1 | MCF_EPORT_EPFR_EPF11);
	printf("\n");
}
/********************************************************************/
