/* tftpport.c
 *
 * Copyright 1997- 2006 By InterNiche Technologies Inc. All rights reserved
 *
 * Portions Copyright 1986 by Carnegie Mellon
 * Portions Copyright 1984 by the Massachusetts Institute of Technology
 *
 * Copyright (c) 1982, 1986, 1988 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation and other 
 * materials related to such distribution and use acknowledge that 
 * the software was developed by the University of California, Berkeley.
 * The name of the University may not be used to endorse or promote 
 * products derived from this software without specific prior written 
 * permission. THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 *
 * Rights, responsibilities and use of this software are controlled by
 * the agreement found in the "LICENSE.H" file distributed with this
 * source code.  "LICENSE.H" may not be removed from this distribution,
 * modified, enhanced nor references to it omitted.
 *
 * TFTP per-port code
 */

#include "license.h"
#include "tftpport.h"
#include "tftp.h"

#include "q.h"
#include "netbuf.h"
#include "net.h"
#include "ip.h"

#include "menu.h"

int   tfs_done(int status, struct tfconn *, char * filename);

#ifdef IN_MENUS
extern struct menu_op tftpmenu[8];
#endif

/* tftp_init() - open UDP port for listen on tftp port, do any prep 
required for client UDP use.

Returns 0 if OK, else negative NP error code.
*/

int
tftp_init()
{
#ifdef TFTP_SERVER
int e;
   e = tfsinit(NULL, tfs_done);
   if(e)
      dprintf("tftp server start err %d\n", e);
#endif   /* TFTP_SERVER */

#ifdef IN_MENUS
   if(install_menu(tftpmenu))
      dprintf("tftp client menu failure\n");
#endif   /* IN_MENUS */

   return 0;
}

#ifdef TFTP_SERVER
/* tfs_done() - server's status callback */

int
tfs_done(int status, struct tfconn * cn, char * msg)
{
ip_addr fhost = cn->tf_fhost;
unsigned dir = cn->tf_dir;

   if(status == 0)
   {
      ns_printf(NULL, "tftp server: moved %lu bytes %s ",
         cn->tf_size, dir==PUT?"to":"from");
      ns_printf(NULL, "%u.%u.%u.%u\n", PUSH_IPADDR(fhost) );
   }
   else  /* error of some kind */
   {
      ns_printf(NULL, "tftp server error: status %d, msg: %s, host:",
         status, msg?msg:"None" );
      ns_printf(NULL, "%u.%u.%u.%u\n", PUSH_IPADDR(fhost) );
   }
   return 0;
}

#endif   /* TFTP_SERVER */

