/*
 * FILENAME: tcpdebug.c
 *
 * Copyright 1997- 2006 By InterNiche Technologies Inc. All rights reserved
 *
 * Portions Copyright 1986 by Carnegie Mellon
 * Portions Copyright 1984 by the Massachusetts Institute of Technology
 *
 * Copyright (c) 1982, 1986, 1988 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation and other 
 * materials related to such distribution and use acknowledge that 
 * the software was developed by the University of California, Berkeley.
 * The name of the University may not be used to endorse or promote 
 * products derived from this software without specific prior written 
 * permission. THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 *
 * Rights, responsibilities and use of this software are controlled by
 * the agreement found in the "LICENSE.H" file distributed with this
 * source code.  "LICENSE.H" may not be removed from this distribution,
 * modified, enhanced nor references to it omitted.
 *
 *
 * MODULE: MTCP
 *
 * ROUTINES: tcp_stat(), tcp_bsdconnstat(), tcp_bsdsendstat(), tcp_bsdrcvstat()
 *
 * PORTABLE: yes
 */


#include "license.h"
#include "ipport.h"
#include "mtcp.h"


#ifdef NET_STATS

/* FUNCTION: tcp_stat()
 *
 * The next few routines pretty-print stats. #define-ing ns_printf 
 * away will minmize space at the expense of utility. They support
 * many ancient (but sometimes still usefull) BSD counters.
 *
 * 
 * PARAM1: void * pio
 *
 * RETURNS: 0
 */

int
tcp_stat(void * pio)
{
   /* MIB-2 tcp group counters */ 
   ns_printf(pio,"tcpRtoAlgorithm %lu,\ttcpRtoMin %lu\n",
    tcpmib.tcpRtoAlgorithm, tcpmib.tcpRtoMin);
   ns_printf(pio,"tcpRtoMax %lu,\ttcpMaxConn %lu\n",
    tcpmib.tcpRtoMax, tcpmib.tcpMaxConn);
   ns_printf(pio,"tcpActiveOpens %lu,\ttcpPassiveOpens %lu\n",
    tcpmib.tcpActiveOpens, tcpmib.tcpPassiveOpens);
   ns_printf(pio,"tcpAttemptFails %lu,\ttcpEstabResets %lu\n",
    tcpmib.tcpAttemptFails, tcpmib.tcpEstabResets);
   ns_printf(pio,"tcpCurrEstab %lu,\ttcpInSegs %lu\n",
    tcpmib.tcpCurrEstab, tcpmib.tcpInSegs);
   ns_printf(pio,"tcpOutSegs %lu,\ttcpRetransSegs %lu\n",
    tcpmib.tcpOutSegs, tcpmib.tcpRetransSegs);
   ns_printf(pio,"tcpInErrs %lu,\ttcpOutRsts %lu\n",
    tcpmib.tcpInErrs, tcpmib.tcpOutRsts);

   return 0;
}


/* FUNCTION: sock_list()
 * 
 * PARAM1: void * pio
 *
 * RETURNS: 
 */

char *   tcpstates[] = 
{
   "CLOSED",
   "LISTEN",
   "SYN_SENT",
   "SYN_RCVD",
   "ESTABLISHED",
   "CLOSE_WAIT",
   "FIN_WAIT_1",
   "CLOSING",
   "LAST_ACK",
   "FIN_WAIT_2",
   "TIME_WAIT",
};

int
sock_list(void * pio)
{
   M_SOCK so;
   struct tcpcb * tp;

   if (msoq.q_len == 0)
   {
      ns_printf(pio,"No TCP sockets\n");
      return 0;
   }

   ns_printf(pio,
    "TCP sock, fhost,     ports,    opts, rxbytes, txbytes, snd_una, snd_nxt, state:\n");
   for (so = (M_SOCK)msoq.q_head; so; so = so->next)
   {
      ns_printf(pio,"%lx,  %u.%u.%u.%u, %u->%u, ", /*(long)*/so, 
         PUSH_IPADDR(so->fhost), (so->lport), (so->fport));

      ns_printf(pio,"0x%x, %u, %u", (unsigned)so->so_options,
         (unsigned)so->rcvdq.sb_cc, (unsigned)so->sendq.sb_cc);

      tp = so->tp;
      if(tp)
         ns_printf(pio, ", %ld, %ld, %s\n", tp->snd_una, tp->snd_nxt, tcpstates[tp->t_state]);
      else
         ns_printf(pio, " (no TCPCB)\n");
   }
   return 0;
}


/* FUNCTION: tcp_bsdconnstat()
 *
 * BSD connection statistics
 *
 * 
 * PARAM1: void * pio
 *
 * RETURNS: 0
 */

int
tcp_bsdconnstat(void * pio)
{
   ns_printf(pio,"connections initiated: %lu,\tconnections accepted: %lu\n",
    tcpstat.tcps_connattempt, tcpstat.tcps_accepts);
   ns_printf(pio,"connections established: %lu,\tconnections dropped: %lu\n",
    tcpstat.tcps_connects, tcpstat.tcps_drops);
   ns_printf(pio,"embryonic connections dropped: %lu,\tconn. closed (includes drops): %lu\n",
    tcpstat.tcps_conndrops, tcpstat.tcps_closed);
   ns_printf(pio,"segs where we tried to get rtt: %lu,\ttimes we succeeded: %lu\n",
    tcpstat.tcps_segstimed, tcpstat.tcps_rttupdated);
   ns_printf(pio,"delayed acks sent: %lu,\tconn. dropped in rxmt timeout: %lu\n",
    tcpstat.tcps_delack, tcpstat.tcps_timeoutdrop);
   ns_printf(pio,"retransmit timeouts: %lu,\tpersist timeouts: %lu\n",
    tcpstat.tcps_rexmttimeo, tcpstat.tcps_persisttimeo);
   ns_printf(pio,"keepalive timeouts: %lu,\tkeepalive probes sent: %lu\n",
    tcpstat.tcps_keeptimeo, tcpstat.tcps_keepprobe);
   ns_printf(pio,"connections dropped in keepalive: %lu\n", tcpstat.tcps_keepdrops);

   return 0;
}




/* FUNCTION: tcp_bsdsendstat()
 * 
 * BSD TCP send stats
 *
 * PARAM1: void * pio
 *
 * RETURNS: 0
 */

int
tcp_bsdsendstat(void * pio)
{

   ns_printf(pio,"total packets sent: %lu,\tdata packets sent: %lu\n",
    tcpstat.tcps_sndtotal, tcpstat.tcps_sndpack);
   ns_printf(pio,"data bytes sent: %lu,\tdata packets retransmitted: %lu\n",
    tcpstat.tcps_sndbyte, tcpstat.tcps_sndrexmitpack);
   ns_printf(pio,"data bytes retransmitted: %lu,\tack-only packets sent: %lu\n",
    tcpstat.tcps_sndrexmitbyte, tcpstat.tcps_sndacks);
   ns_printf(pio,"window probes sent: %lu,\tpackets sent with URG only: %lu\n",
    tcpstat.tcps_sndprobe, tcpstat.tcps_sndurg);
   ns_printf(pio,"window update-only packets sent: %lu,\tcontrol (SYN|FIN|RST) packets sent: %lu\n",
    tcpstat.tcps_sndwinup, tcpstat.tcps_sndctrl);

   return 0;
}



/* FUNCTION: tcp_bsdrcvstat()
 *
 *  BSD TCP receive stats
 *
 * 
 * PARAM1: void * pio
 *
 * RETURNS: 0
 */

int
tcp_bsdrcvstat(void * pio)
{
   ns_printf(pio,"total packets received: %lu,\tpackets received in sequence: %lu\n",
    tcpstat.tcps_rcvtotal, tcpstat.tcps_rcvpack);
   ns_printf(pio,"bytes received in sequence: %lu,\tpackets received with ccksum errs: %lu\n",
    tcpstat.tcps_rcvbyte, tcpstat.tcps_rcvbadsum);
   ns_printf(pio,"packets received with bad offset: %lu,\tpackets received too short: %lu\n",
    tcpstat.tcps_rcvbadoff, tcpstat.tcps_rcvshort);
   ns_printf(pio,"duplicate-only packets received: %lu,\tduplicate-only bytes received: %lu\n",
    tcpstat.tcps_rcvduppack, tcpstat.tcps_rcvdupbyte);
   ns_printf(pio,"packets with some duplicate data: %lu,\tdup. bytes in part-dup. packets: %lu\n",
    tcpstat.tcps_rcvpartduppack, tcpstat.tcps_rcvpartdupbyte);
   ns_printf(pio,"out-of-order packets received: %lu,\tout-of-order bytes received: %lu\n",
    tcpstat.tcps_rcvoopack, tcpstat.tcps_rcvoobyte);
   ns_printf(pio,"packets with data after window: %lu,\tbytes rcvd after window: %lu\n",
    tcpstat.tcps_rcvpackafterwin, tcpstat.tcps_rcvbyteafterwin);
   ns_printf(pio,"packets rcvd after close: %lu,\trcvd window probe packets: %lu\n",
    tcpstat.tcps_rcvafterclose, tcpstat.tcps_rcvwinprobe);
   ns_printf(pio,"rcvd duplicate acks: %lu,\trcvd acks for unsent data: %lu\n",
    tcpstat.tcps_rcvdupack, tcpstat.tcps_rcvacktoomuch);
   ns_printf(pio,"rcvd ack packets: %lu,\tbytes acked by rcvd acks: %lu\n",
    tcpstat.tcps_rcvackpack, tcpstat.tcps_rcvackbyte);
   ns_printf(pio,"rcvd window update packets: %lu\n", tcpstat.tcps_rcvwinupd);
   ns_printf(pio,"rcvd predictive header hits; acks:%lu, data:%lu\n",
    tcpstat.tcps_predack, tcpstat.tcps_preddat);
   return 0;
}

#endif   /* NET_STATS */
