/*
 * File:		mcf52xx.c
 * Purpose:		Source to select CF derivative
 *
 * Notes:
 */
/********************************************************************/
#include "common.h"

extern int d0_reset;
extern int d1_reset;

/********************************************************************/
void
cpu_startup (void)
{
#ifdef DEBUG_PRINT
  uint32 myctr; 		//generic counter variable
    /*
     * Determine cause(s) of reset
     */
    printf("\n");
    if (MCF_SCM_CRSR & MCF_SCM_CRSR_CWDR)
        printf("Core Watchdog Time Reset\n");
    if (MCF_CIM_RSR & MCF_CIM_RSR_LVD)
        printf("Low Voltage Detect Reset\n");
    if (MCF_CIM_RSR & MCF_CIM_RSR_SOFT)
        printf("Software Reset\n");
    if (MCF_CIM_RSR & MCF_CIM_RSR_WDR)
        printf("Watchdog Timer Reset\n");
    if (MCF_CIM_RSR & MCF_CIM_RSR_POR)
        printf("Power-on Reset\n");
    if (MCF_CIM_RSR & MCF_CIM_RSR_EXT)
        printf("External Reset\n");
    if (MCF_CIM_RSR & MCF_CIM_RSR_LOC)
        printf("Loss of Clock Reset\n");
    if (MCF_CIM_RSR & MCF_CIM_RSR_LOL)
        printf("Loss of PLL Lock Reset\n");

    /*
     * Identify which MCU of which revision we are executing on
     */
    switch ((MCF_CIM_CIR & 0xFFC0) >> 6)
    {
        case 0x48:
            printf("MCF5221");
            break;
        case 0x4A:
            printf("MCF5222");
            break;
        case 0x4C:
            printf("MCF5223");
            break;
        default:
            printf("Unknown ");
            break;
    }
    printf(" Rev. %d",(MCF_CIM_CIR & 0x003F));
	printf(" \nCore Initialization Complete!\n");
	printf("Chip ID: %02x\n",(MCF_CIM_CIR>>6));
	for (myctr=20000; myctr >0; myctr--){uart_isr(0);}

    /*
     * Print out the core integration information
     */
   mcf5xxx_interpret_d0d1(d0_reset,d1_reset);
	for (myctr=20000; myctr >0; myctr--){uart_isr(0);}
#endif

    /* 
	 * Enable on-chip modules to access internal SRAM 
	 */
	MCF_SCM_RAMBAR = 0
	    | MCF_SCM_RAMBAR_BA(SRAM_ADDRESS)
        | MCF_SCM_RAMBAR_BDE;
}
/*
 * Setup PIT Timer
 */
void 
PIT_Timer_Init(uint8 PCSR, uint16 PMR)
{

	/* Set tic for timers	*/

	MCF_PIT0_PCSR  = (uint16)(MCF_PIT_PCSR_PRE(PCSR));	/* Divide system clock/2 by 2^PCSR	*/
	MCF_INTC0_ICR55 = MCF_INTC_ICR_IL(TIMER_NETWORK_LEVEL);
	MCF_INTC0_IMRH &= ~MCF_INTC_IMRH_MASK55;
	MCF_PIT0_PMR = PMR;						/* modulo count	*/
	MCF_PIT0_PCSR |= MCF_PIT_PCSR_OVW | MCF_PIT_PCSR_PIE |
	                 MCF_PIT_PCSR_PIF | MCF_PIT_PCSR_RLD |
	                 MCF_PIT_PCSR_EN;
}

//jpw fix
/* FUNCTION: clock_c()
 * 
 * Disable timer interrupts
 *
 * PARAM1: none
 *
 * RETURNS: none
 */

void
clock_c()
{
   MCF_PIT_PCSR(0) &= ~( MCF_PIT_PCSR_PIE | MCF_PIT_PCSR_EN );

   printf("clock_c: disabling timer interrupts\n");
}


/********************************************************************/
/*
 * Pause for the specified number of micro-seconds.
 * Uses DTIM3 as a timer
 */
void
cpu_pause(int usecs)
{
    /* Enable the DMA Timer 3 */
    MCF_DTIM3_DTRR = (vuint32)(usecs - 1);
    MCF_DTIM3_DTER = MCF_DTIM_DTER_REF;
    MCF_DTIM3_DTMR = 0
        | MCF_DTIM_DTMR_PS(SYSTEM_CLOCK)
        | MCF_DTIM_DTMR_ORRI
        | MCF_DTIM_DTMR_FRR
        | MCF_DTIM_DTMR_CLK_DIV1
        | MCF_DTIM_DTMR_RST;

    while ((MCF_DTIM3_DTER & MCF_DTIM_DTER_REF) == 0) 
    {};
    
    /* Disable the timer */
    MCF_DTIM3_DTMR = 0;
}

/********************************************************************/
void
board_handle_interrupt (int vector)
{
    switch (vector)
    {
        case 68: /* Eport Interrupt 4 */
            printf("SW1\n");
            MCF_EPORT_EPFR1 = (uint8)(0x01 << 4);
            break;
        case 69: /* Eport Interrupt 5 */
            printf("SW2\n");
            MCF_EPORT_EPFR1 = (uint8)(0x01 << 5);
            break;
        case 71: /* Eport Interrupt 7 */
            printf("ABORT\n");
            MCF_EPORT_EPFR1 = (uint8)(0x01 << 7);
            break;
        case 65: /* Eport Interrupt 1 */
        case 66: /* Eport Interrupt 2 */
        case 67: /* Eport Interrupt 3 */
        case 70: /* Eport Interrupt 6 */
        default:
            MCF_EPORT_EPFR1 = (uint8)(0x01 << (vector - 64));
            printf("Edge Port Interrupt #%d\n",vector - 64);
            break;
    }
}
/********************************************************************/

/********************************************************************/
void
cpu_handle_interrupt (int vector)
{
    if (vector < 64 || vector > 192)
        return;
    
    if (vector >= 64 && vector <= 71)
        board_handle_interrupt(vector);
    else
        printf("User Defined Vector #%d\n",vector);
}
/********************************************************************/
/********************************************************************/

void 
mcf5223_interrupt_init(int source, int ipl, void (*func)(void))
{
ADDRESS old_handler;
   if ((source >= 0) && (source <= 63)) 
   {
      MCF_INTC0_ICR(source) = ipl;
      old_handler = mcf5xxx_set_handler(source+64, (ADDRESS)func);
//jpw      MCF_INTC_CIMR = MCF_INTC_CIMR_CIMR(source);
   }
}
/********************************************************************/
