/*
 * File:    mcf5223_intc.h
 * Purpose: Register and bit definitions
 */

#ifndef __MCF5223_INTC_H__
#define __MCF5223_INTC_H__

/*********************************************************************
*
* Interrupt Controller (INTC)
*
*********************************************************************/

/* Register read/write macros */
#define MCF_INTC0_IPRH             (*(vuint32*)(&__IPSBAR[0x000C00]))
#define MCF_INTC0_IPRL             (*(vuint32*)(&__IPSBAR[0x000C04]))
#define MCF_INTC0_IMRH             (*(vuint32*)(&__IPSBAR[0x000C08]))
#define MCF_INTC0_IMRL             (*(vuint32*)(&__IPSBAR[0x000C0C]))
#define MCF_INTC0_INTFRCH          (*(vuint32*)(&__IPSBAR[0x000C10]))
#define MCF_INTC0_INTFRCL          (*(vuint32*)(&__IPSBAR[0x000C14]))
#define MCF_INTC0_IRLR             (*(vuint8 *)(&__IPSBAR[0x000C18]))
#define MCF_INTC0_IACKLPR          (*(vuint8 *)(&__IPSBAR[0x000C19]))
#define MCF_INTC0_ICR1             (*(vuint8 *)(&__IPSBAR[0x000C41]))
#define MCF_INTC0_ICR2             (*(vuint8 *)(&__IPSBAR[0x000C42]))
#define MCF_INTC0_ICR3             (*(vuint8 *)(&__IPSBAR[0x000C43]))
#define MCF_INTC0_ICR4             (*(vuint8 *)(&__IPSBAR[0x000C44]))
#define MCF_INTC0_ICR5             (*(vuint8 *)(&__IPSBAR[0x000C45]))
#define MCF_INTC0_ICR6             (*(vuint8 *)(&__IPSBAR[0x000C46]))
#define MCF_INTC0_ICR7             (*(vuint8 *)(&__IPSBAR[0x000C47]))
#define MCF_INTC0_ICR8             (*(vuint8 *)(&__IPSBAR[0x000C48]))
#define MCF_INTC0_ICR9             (*(vuint8 *)(&__IPSBAR[0x000C49]))
#define MCF_INTC0_ICR10            (*(vuint8 *)(&__IPSBAR[0x000C4A]))
#define MCF_INTC0_ICR11            (*(vuint8 *)(&__IPSBAR[0x000C4B]))
#define MCF_INTC0_ICR12            (*(vuint8 *)(&__IPSBAR[0x000C4C]))
#define MCF_INTC0_ICR13            (*(vuint8 *)(&__IPSBAR[0x000C4D]))
#define MCF_INTC0_ICR14            (*(vuint8 *)(&__IPSBAR[0x000C4E]))
#define MCF_INTC0_ICR15            (*(vuint8 *)(&__IPSBAR[0x000C4F]))
#define MCF_INTC0_ICR16            (*(vuint8 *)(&__IPSBAR[0x000C50]))
#define MCF_INTC0_ICR17            (*(vuint8 *)(&__IPSBAR[0x000C51]))
#define MCF_INTC0_ICR18            (*(vuint8 *)(&__IPSBAR[0x000C52]))
#define MCF_INTC0_ICR19            (*(vuint8 *)(&__IPSBAR[0x000C53]))
#define MCF_INTC0_ICR20            (*(vuint8 *)(&__IPSBAR[0x000C54]))
#define MCF_INTC0_ICR21            (*(vuint8 *)(&__IPSBAR[0x000C55]))
#define MCF_INTC0_ICR22            (*(vuint8 *)(&__IPSBAR[0x000C56]))
#define MCF_INTC0_ICR23            (*(vuint8 *)(&__IPSBAR[0x000C57]))
#define MCF_INTC0_ICR24            (*(vuint8 *)(&__IPSBAR[0x000C58]))
#define MCF_INTC0_ICR25            (*(vuint8 *)(&__IPSBAR[0x000C59]))
#define MCF_INTC0_ICR26            (*(vuint8 *)(&__IPSBAR[0x000C5A]))
#define MCF_INTC0_ICR27            (*(vuint8 *)(&__IPSBAR[0x000C5B]))
#define MCF_INTC0_ICR28            (*(vuint8 *)(&__IPSBAR[0x000C5C]))
#define MCF_INTC0_ICR29            (*(vuint8 *)(&__IPSBAR[0x000C5D]))
#define MCF_INTC0_ICR30            (*(vuint8 *)(&__IPSBAR[0x000C5E]))
#define MCF_INTC0_ICR31            (*(vuint8 *)(&__IPSBAR[0x000C5F]))
#define MCF_INTC0_ICR32            (*(vuint8 *)(&__IPSBAR[0x000C60]))
#define MCF_INTC0_ICR33            (*(vuint8 *)(&__IPSBAR[0x000C61]))
#define MCF_INTC0_ICR34            (*(vuint8 *)(&__IPSBAR[0x000C62]))
#define MCF_INTC0_ICR35            (*(vuint8 *)(&__IPSBAR[0x000C63]))
#define MCF_INTC0_ICR36            (*(vuint8 *)(&__IPSBAR[0x000C64]))
#define MCF_INTC0_ICR37            (*(vuint8 *)(&__IPSBAR[0x000C65]))
#define MCF_INTC0_ICR38            (*(vuint8 *)(&__IPSBAR[0x000C66]))
#define MCF_INTC0_ICR39            (*(vuint8 *)(&__IPSBAR[0x000C67]))
#define MCF_INTC0_ICR40            (*(vuint8 *)(&__IPSBAR[0x000C68]))
#define MCF_INTC0_ICR41            (*(vuint8 *)(&__IPSBAR[0x000C69]))
#define MCF_INTC0_ICR42            (*(vuint8 *)(&__IPSBAR[0x000C6A]))
#define MCF_INTC0_ICR43            (*(vuint8 *)(&__IPSBAR[0x000C6B]))
#define MCF_INTC0_ICR44            (*(vuint8 *)(&__IPSBAR[0x000C6C]))
#define MCF_INTC0_ICR45            (*(vuint8 *)(&__IPSBAR[0x000C6D]))
#define MCF_INTC0_ICR46            (*(vuint8 *)(&__IPSBAR[0x000C6E]))
#define MCF_INTC0_ICR47            (*(vuint8 *)(&__IPSBAR[0x000C6F]))
#define MCF_INTC0_ICR48            (*(vuint8 *)(&__IPSBAR[0x000C70]))
#define MCF_INTC0_ICR49            (*(vuint8 *)(&__IPSBAR[0x000C71]))
#define MCF_INTC0_ICR50            (*(vuint8 *)(&__IPSBAR[0x000C72]))
#define MCF_INTC0_ICR51            (*(vuint8 *)(&__IPSBAR[0x000C73]))
#define MCF_INTC0_ICR52            (*(vuint8 *)(&__IPSBAR[0x000C74]))
#define MCF_INTC0_ICR53            (*(vuint8 *)(&__IPSBAR[0x000C75]))
#define MCF_INTC0_ICR54            (*(vuint8 *)(&__IPSBAR[0x000C76]))
#define MCF_INTC0_ICR55            (*(vuint8 *)(&__IPSBAR[0x000C77]))
#define MCF_INTC0_ICR56            (*(vuint8 *)(&__IPSBAR[0x000C78]))
#define MCF_INTC0_ICR57            (*(vuint8 *)(&__IPSBAR[0x000C79]))
#define MCF_INTC0_ICR58            (*(vuint8 *)(&__IPSBAR[0x000C7A]))
#define MCF_INTC0_ICR59            (*(vuint8 *)(&__IPSBAR[0x000C7B]))
#define MCF_INTC0_ICR60            (*(vuint8 *)(&__IPSBAR[0x000C7C]))
#define MCF_INTC0_ICR61            (*(vuint8 *)(&__IPSBAR[0x000C7D]))
#define MCF_INTC0_ICR62            (*(vuint8 *)(&__IPSBAR[0x000C7E]))
#define MCF_INTC0_ICR63            (*(vuint8 *)(&__IPSBAR[0x000C7F]))
#define MCF_INTC0_ICR(x)           (*(vuint8 *)(&__IPSBAR[0x000C41+((x-1)*0x001)]))
#define MCF_INTC0_SWIACK           (*(vuint8 *)(&__IPSBAR[0x000CE0]))
#define MCF_INTC0_L1IACK           (*(vuint8 *)(&__IPSBAR[0x000CE4]))
#define MCF_INTC0_L2IACK           (*(vuint8 *)(&__IPSBAR[0x000CE8]))
#define MCF_INTC0_L3IACK           (*(vuint8 *)(&__IPSBAR[0x000CEC]))
#define MCF_INTC0_L4IACK           (*(vuint8 *)(&__IPSBAR[0x000CF0]))
#define MCF_INTC0_L5IACK           (*(vuint8 *)(&__IPSBAR[0x000CF4]))
#define MCF_INTC0_L6IACK           (*(vuint8 *)(&__IPSBAR[0x000CF8]))
#define MCF_INTC0_L7IACK           (*(vuint8 *)(&__IPSBAR[0x000CFC]))
#define MCF_INTC0_LIACK(x)         (*(vuint8 *)(&__IPSBAR[0x000CE4+((x-1)*0x004)]))
#define MCF_INTC1_IPRH             (*(vuint32*)(&__IPSBAR[0x000D00]))
#define MCF_INTC1_IPRL             (*(vuint32*)(&__IPSBAR[0x000D04]))
#define MCF_INTC1_IMRH             (*(vuint32*)(&__IPSBAR[0x000D08]))
#define MCF_INTC1_IMRL             (*(vuint32*)(&__IPSBAR[0x000D0C]))
#define MCF_INTC1_INTFRCH          (*(vuint32*)(&__IPSBAR[0x000D10]))
#define MCF_INTC1_INTFRCL          (*(vuint32*)(&__IPSBAR[0x000D14]))
#define MCF_INTC1_IRLR             (*(vuint8 *)(&__IPSBAR[0x000D18]))
#define MCF_INTC1_IACKLPR          (*(vuint8 *)(&__IPSBAR[0x000D19]))
#define MCF_INTC1_ICR1             (*(vuint8 *)(&__IPSBAR[0x000D41]))
#define MCF_INTC1_ICR2             (*(vuint8 *)(&__IPSBAR[0x000D42]))
#define MCF_INTC1_ICR3             (*(vuint8 *)(&__IPSBAR[0x000D43]))
#define MCF_INTC1_ICR4             (*(vuint8 *)(&__IPSBAR[0x000D44]))
#define MCF_INTC1_ICR5             (*(vuint8 *)(&__IPSBAR[0x000D45]))
#define MCF_INTC1_ICR6             (*(vuint8 *)(&__IPSBAR[0x000D46]))
#define MCF_INTC1_ICR7             (*(vuint8 *)(&__IPSBAR[0x000D47]))
#define MCF_INTC1_ICR8             (*(vuint8 *)(&__IPSBAR[0x000D48]))
#define MCF_INTC1_ICR9             (*(vuint8 *)(&__IPSBAR[0x000D49]))
#define MCF_INTC1_ICR10            (*(vuint8 *)(&__IPSBAR[0x000D4A]))
#define MCF_INTC1_ICR11            (*(vuint8 *)(&__IPSBAR[0x000D4B]))
#define MCF_INTC1_ICR12            (*(vuint8 *)(&__IPSBAR[0x000D4C]))
#define MCF_INTC1_ICR13            (*(vuint8 *)(&__IPSBAR[0x000D4D]))
#define MCF_INTC1_ICR14            (*(vuint8 *)(&__IPSBAR[0x000D4E]))
#define MCF_INTC1_ICR15            (*(vuint8 *)(&__IPSBAR[0x000D4F]))
#define MCF_INTC1_ICR16            (*(vuint8 *)(&__IPSBAR[0x000D50]))
#define MCF_INTC1_ICR17            (*(vuint8 *)(&__IPSBAR[0x000D51]))
#define MCF_INTC1_ICR18            (*(vuint8 *)(&__IPSBAR[0x000D52]))
#define MCF_INTC1_ICR19            (*(vuint8 *)(&__IPSBAR[0x000D53]))
#define MCF_INTC1_ICR20            (*(vuint8 *)(&__IPSBAR[0x000D54]))
#define MCF_INTC1_ICR21            (*(vuint8 *)(&__IPSBAR[0x000D55]))
#define MCF_INTC1_ICR22            (*(vuint8 *)(&__IPSBAR[0x000D56]))
#define MCF_INTC1_ICR23            (*(vuint8 *)(&__IPSBAR[0x000D57]))
#define MCF_INTC1_ICR24            (*(vuint8 *)(&__IPSBAR[0x000D58]))
#define MCF_INTC1_ICR25            (*(vuint8 *)(&__IPSBAR[0x000D59]))
#define MCF_INTC1_ICR26            (*(vuint8 *)(&__IPSBAR[0x000D5A]))
#define MCF_INTC1_ICR27            (*(vuint8 *)(&__IPSBAR[0x000D5B]))
#define MCF_INTC1_ICR28            (*(vuint8 *)(&__IPSBAR[0x000D5C]))
#define MCF_INTC1_ICR29            (*(vuint8 *)(&__IPSBAR[0x000D5D]))
#define MCF_INTC1_ICR30            (*(vuint8 *)(&__IPSBAR[0x000D5E]))
#define MCF_INTC1_ICR31            (*(vuint8 *)(&__IPSBAR[0x000D5F]))
#define MCF_INTC1_ICR32            (*(vuint8 *)(&__IPSBAR[0x000D60]))
#define MCF_INTC1_ICR33            (*(vuint8 *)(&__IPSBAR[0x000D61]))
#define MCF_INTC1_ICR34            (*(vuint8 *)(&__IPSBAR[0x000D62]))
#define MCF_INTC1_ICR35            (*(vuint8 *)(&__IPSBAR[0x000D63]))
#define MCF_INTC1_ICR36            (*(vuint8 *)(&__IPSBAR[0x000D64]))
#define MCF_INTC1_ICR37            (*(vuint8 *)(&__IPSBAR[0x000D65]))
#define MCF_INTC1_ICR38            (*(vuint8 *)(&__IPSBAR[0x000D66]))
#define MCF_INTC1_ICR39            (*(vuint8 *)(&__IPSBAR[0x000D67]))
#define MCF_INTC1_ICR40            (*(vuint8 *)(&__IPSBAR[0x000D68]))
#define MCF_INTC1_ICR41            (*(vuint8 *)(&__IPSBAR[0x000D69]))
#define MCF_INTC1_ICR42            (*(vuint8 *)(&__IPSBAR[0x000D6A]))
#define MCF_INTC1_ICR43            (*(vuint8 *)(&__IPSBAR[0x000D6B]))
#define MCF_INTC1_ICR44            (*(vuint8 *)(&__IPSBAR[0x000D6C]))
#define MCF_INTC1_ICR45            (*(vuint8 *)(&__IPSBAR[0x000D6D]))
#define MCF_INTC1_ICR46            (*(vuint8 *)(&__IPSBAR[0x000D6E]))
#define MCF_INTC1_ICR47            (*(vuint8 *)(&__IPSBAR[0x000D6F]))
#define MCF_INTC1_ICR48            (*(vuint8 *)(&__IPSBAR[0x000D70]))
#define MCF_INTC1_ICR49            (*(vuint8 *)(&__IPSBAR[0x000D71]))
#define MCF_INTC1_ICR50            (*(vuint8 *)(&__IPSBAR[0x000D72]))
#define MCF_INTC1_ICR51            (*(vuint8 *)(&__IPSBAR[0x000D73]))
#define MCF_INTC1_ICR52            (*(vuint8 *)(&__IPSBAR[0x000D74]))
#define MCF_INTC1_ICR53            (*(vuint8 *)(&__IPSBAR[0x000D75]))
#define MCF_INTC1_ICR54            (*(vuint8 *)(&__IPSBAR[0x000D76]))
#define MCF_INTC1_ICR55            (*(vuint8 *)(&__IPSBAR[0x000D77]))
#define MCF_INTC1_ICR56            (*(vuint8 *)(&__IPSBAR[0x000D78]))
#define MCF_INTC1_ICR57            (*(vuint8 *)(&__IPSBAR[0x000D79]))
#define MCF_INTC1_ICR58            (*(vuint8 *)(&__IPSBAR[0x000D7A]))
#define MCF_INTC1_ICR59            (*(vuint8 *)(&__IPSBAR[0x000D7B]))
#define MCF_INTC1_ICR60            (*(vuint8 *)(&__IPSBAR[0x000D7C]))
#define MCF_INTC1_ICR61            (*(vuint8 *)(&__IPSBAR[0x000D7D]))
#define MCF_INTC1_ICR62            (*(vuint8 *)(&__IPSBAR[0x000D7E]))
#define MCF_INTC1_ICR63            (*(vuint8 *)(&__IPSBAR[0x000D7F]))
#define MCF_INTC1_ICR(x)           (*(vuint8 *)(&__IPSBAR[0x000D41+((x-1)*0x001)]))
#define MCF_INTC1_SWIACK           (*(vuint8 *)(&__IPSBAR[0x000DE0]))
#define MCF_INTC1_L1IACK           (*(vuint8 *)(&__IPSBAR[0x000DE4]))
#define MCF_INTC1_L2IACK           (*(vuint8 *)(&__IPSBAR[0x000DE8]))
#define MCF_INTC1_L3IACK           (*(vuint8 *)(&__IPSBAR[0x000DEC]))
#define MCF_INTC1_L4IACK           (*(vuint8 *)(&__IPSBAR[0x000DF0]))
#define MCF_INTC1_L5IACK           (*(vuint8 *)(&__IPSBAR[0x000DF4]))
#define MCF_INTC1_L6IACK           (*(vuint8 *)(&__IPSBAR[0x000DF8]))
#define MCF_INTC1_L7IACK           (*(vuint8 *)(&__IPSBAR[0x000DFC]))
#define MCF_INTC1_LIACK(x)         (*(vuint8 *)(&__IPSBAR[0x000DE4+((x-1)*0x004)]))
#define MCF_INTC_IPRH(x)           (*(vuint32*)(&__IPSBAR[0x000C00+((x)*0x100)]))
#define MCF_INTC_IPRL(x)           (*(vuint32*)(&__IPSBAR[0x000C04+((x)*0x100)]))
#define MCF_INTC_IMRH(x)           (*(vuint32*)(&__IPSBAR[0x000C08+((x)*0x100)]))
#define MCF_INTC_IMRL(x)           (*(vuint32*)(&__IPSBAR[0x000C0C+((x)*0x100)]))
#define MCF_INTC_INTFRCH(x)        (*(vuint32*)(&__IPSBAR[0x000C10+((x)*0x100)]))
#define MCF_INTC_INTFRCL(x)        (*(vuint32*)(&__IPSBAR[0x000C14+((x)*0x100)]))
#define MCF_INTC_IRLR(x)           (*(vuint8 *)(&__IPSBAR[0x000C18+((x)*0x100)]))
#define MCF_INTC_IACKLPR(x)        (*(vuint8 *)(&__IPSBAR[0x000C19+((x)*0x100)]))
#define MCF_INTC_ICR1(x)           (*(vuint8 *)(&__IPSBAR[0x000C41+((x)*0x100)]))
#define MCF_INTC_ICR2(x)           (*(vuint8 *)(&__IPSBAR[0x000C42+((x)*0x100)]))
#define MCF_INTC_ICR3(x)           (*(vuint8 *)(&__IPSBAR[0x000C43+((x)*0x100)]))
#define MCF_INTC_ICR4(x)           (*(vuint8 *)(&__IPSBAR[0x000C44+((x)*0x100)]))
#define MCF_INTC_ICR5(x)           (*(vuint8 *)(&__IPSBAR[0x000C45+((x)*0x100)]))
#define MCF_INTC_ICR6(x)           (*(vuint8 *)(&__IPSBAR[0x000C46+((x)*0x100)]))
#define MCF_INTC_ICR7(x)           (*(vuint8 *)(&__IPSBAR[0x000C47+((x)*0x100)]))
#define MCF_INTC_ICR8(x)           (*(vuint8 *)(&__IPSBAR[0x000C48+((x)*0x100)]))
#define MCF_INTC_ICR9(x)           (*(vuint8 *)(&__IPSBAR[0x000C49+((x)*0x100)]))
#define MCF_INTC_ICR10(x)          (*(vuint8 *)(&__IPSBAR[0x000C4A+((x)*0x100)]))
#define MCF_INTC_ICR11(x)          (*(vuint8 *)(&__IPSBAR[0x000C4B+((x)*0x100)]))
#define MCF_INTC_ICR12(x)          (*(vuint8 *)(&__IPSBAR[0x000C4C+((x)*0x100)]))
#define MCF_INTC_ICR13(x)          (*(vuint8 *)(&__IPSBAR[0x000C4D+((x)*0x100)]))
#define MCF_INTC_ICR14(x)          (*(vuint8 *)(&__IPSBAR[0x000C4E+((x)*0x100)]))
#define MCF_INTC_ICR15(x)          (*(vuint8 *)(&__IPSBAR[0x000C4F+((x)*0x100)]))
#define MCF_INTC_ICR16(x)          (*(vuint8 *)(&__IPSBAR[0x000C50+((x)*0x100)]))
#define MCF_INTC_ICR17(x)          (*(vuint8 *)(&__IPSBAR[0x000C51+((x)*0x100)]))
#define MCF_INTC_ICR18(x)          (*(vuint8 *)(&__IPSBAR[0x000C52+((x)*0x100)]))
#define MCF_INTC_ICR19(x)          (*(vuint8 *)(&__IPSBAR[0x000C53+((x)*0x100)]))
#define MCF_INTC_ICR20(x)          (*(vuint8 *)(&__IPSBAR[0x000C54+((x)*0x100)]))
#define MCF_INTC_ICR21(x)          (*(vuint8 *)(&__IPSBAR[0x000C55+((x)*0x100)]))
#define MCF_INTC_ICR22(x)          (*(vuint8 *)(&__IPSBAR[0x000C56+((x)*0x100)]))
#define MCF_INTC_ICR23(x)          (*(vuint8 *)(&__IPSBAR[0x000C57+((x)*0x100)]))
#define MCF_INTC_ICR24(x)          (*(vuint8 *)(&__IPSBAR[0x000C58+((x)*0x100)]))
#define MCF_INTC_ICR25(x)          (*(vuint8 *)(&__IPSBAR[0x000C59+((x)*0x100)]))
#define MCF_INTC_ICR26(x)          (*(vuint8 *)(&__IPSBAR[0x000C5A+((x)*0x100)]))
#define MCF_INTC_ICR27(x)          (*(vuint8 *)(&__IPSBAR[0x000C5B+((x)*0x100)]))
#define MCF_INTC_ICR28(x)          (*(vuint8 *)(&__IPSBAR[0x000C5C+((x)*0x100)]))
#define MCF_INTC_ICR29(x)          (*(vuint8 *)(&__IPSBAR[0x000C5D+((x)*0x100)]))
#define MCF_INTC_ICR30(x)          (*(vuint8 *)(&__IPSBAR[0x000C5E+((x)*0x100)]))
#define MCF_INTC_ICR31(x)          (*(vuint8 *)(&__IPSBAR[0x000C5F+((x)*0x100)]))
#define MCF_INTC_ICR32(x)          (*(vuint8 *)(&__IPSBAR[0x000C60+((x)*0x100)]))
#define MCF_INTC_ICR33(x)          (*(vuint8 *)(&__IPSBAR[0x000C61+((x)*0x100)]))
#define MCF_INTC_ICR34(x)          (*(vuint8 *)(&__IPSBAR[0x000C62+((x)*0x100)]))
#define MCF_INTC_ICR35(x)          (*(vuint8 *)(&__IPSBAR[0x000C63+((x)*0x100)]))
#define MCF_INTC_ICR36(x)          (*(vuint8 *)(&__IPSBAR[0x000C64+((x)*0x100)]))
#define MCF_INTC_ICR37(x)          (*(vuint8 *)(&__IPSBAR[0x000C65+((x)*0x100)]))
#define MCF_INTC_ICR38(x)          (*(vuint8 *)(&__IPSBAR[0x000C66+((x)*0x100)]))
#define MCF_INTC_ICR39(x)          (*(vuint8 *)(&__IPSBAR[0x000C67+((x)*0x100)]))
#define MCF_INTC_ICR40(x)          (*(vuint8 *)(&__IPSBAR[0x000C68+((x)*0x100)]))
#define MCF_INTC_ICR41(x)          (*(vuint8 *)(&__IPSBAR[0x000C69+((x)*0x100)]))
#define MCF_INTC_ICR42(x)          (*(vuint8 *)(&__IPSBAR[0x000C6A+((x)*0x100)]))
#define MCF_INTC_ICR43(x)          (*(vuint8 *)(&__IPSBAR[0x000C6B+((x)*0x100)]))
#define MCF_INTC_ICR44(x)          (*(vuint8 *)(&__IPSBAR[0x000C6C+((x)*0x100)]))
#define MCF_INTC_ICR45(x)          (*(vuint8 *)(&__IPSBAR[0x000C6D+((x)*0x100)]))
#define MCF_INTC_ICR46(x)          (*(vuint8 *)(&__IPSBAR[0x000C6E+((x)*0x100)]))
#define MCF_INTC_ICR47(x)          (*(vuint8 *)(&__IPSBAR[0x000C6F+((x)*0x100)]))
#define MCF_INTC_ICR48(x)          (*(vuint8 *)(&__IPSBAR[0x000C70+((x)*0x100)]))
#define MCF_INTC_ICR49(x)          (*(vuint8 *)(&__IPSBAR[0x000C71+((x)*0x100)]))
#define MCF_INTC_ICR50(x)          (*(vuint8 *)(&__IPSBAR[0x000C72+((x)*0x100)]))
#define MCF_INTC_ICR51(x)          (*(vuint8 *)(&__IPSBAR[0x000C73+((x)*0x100)]))
#define MCF_INTC_ICR52(x)          (*(vuint8 *)(&__IPSBAR[0x000C74+((x)*0x100)]))
#define MCF_INTC_ICR53(x)          (*(vuint8 *)(&__IPSBAR[0x000C75+((x)*0x100)]))
#define MCF_INTC_ICR54(x)          (*(vuint8 *)(&__IPSBAR[0x000C76+((x)*0x100)]))
#define MCF_INTC_ICR55(x)          (*(vuint8 *)(&__IPSBAR[0x000C77+((x)*0x100)]))
#define MCF_INTC_ICR56(x)          (*(vuint8 *)(&__IPSBAR[0x000C78+((x)*0x100)]))
#define MCF_INTC_ICR57(x)          (*(vuint8 *)(&__IPSBAR[0x000C79+((x)*0x100)]))
#define MCF_INTC_ICR58(x)          (*(vuint8 *)(&__IPSBAR[0x000C7A+((x)*0x100)]))
#define MCF_INTC_ICR59(x)          (*(vuint8 *)(&__IPSBAR[0x000C7B+((x)*0x100)]))
#define MCF_INTC_ICR60(x)          (*(vuint8 *)(&__IPSBAR[0x000C7C+((x)*0x100)]))
#define MCF_INTC_ICR61(x)          (*(vuint8 *)(&__IPSBAR[0x000C7D+((x)*0x100)]))
#define MCF_INTC_ICR62(x)          (*(vuint8 *)(&__IPSBAR[0x000C7E+((x)*0x100)]))
#define MCF_INTC_ICR63(x)          (*(vuint8 *)(&__IPSBAR[0x000C7F+((x)*0x100)]))
#define MCF_INTC_SWIACK(x)         (*(vuint8 *)(&__IPSBAR[0x000CE0+((x)*0x100)]))
#define MCF_INTC_L1IACK(x)         (*(vuint8 *)(&__IPSBAR[0x000CE4+((x)*0x100)]))
#define MCF_INTC_L2IACK(x)         (*(vuint8 *)(&__IPSBAR[0x000CE8+((x)*0x100)]))
#define MCF_INTC_L3IACK(x)         (*(vuint8 *)(&__IPSBAR[0x000CEC+((x)*0x100)]))
#define MCF_INTC_L4IACK(x)         (*(vuint8 *)(&__IPSBAR[0x000CF0+((x)*0x100)]))
#define MCF_INTC_L5IACK(x)         (*(vuint8 *)(&__IPSBAR[0x000CF4+((x)*0x100)]))
#define MCF_INTC_L6IACK(x)         (*(vuint8 *)(&__IPSBAR[0x000CF8+((x)*0x100)]))
#define MCF_INTC_L7IACK(x)         (*(vuint8 *)(&__IPSBAR[0x000CFC+((x)*0x100)]))

/* Bit definitions and macros for MCF_INTC_IPRH */
#define MCF_INTC_IPRH_INT32        (0x00000001)
#define MCF_INTC_IPRH_INT33        (0x00000002)
#define MCF_INTC_IPRH_INT34        (0x00000004)
#define MCF_INTC_IPRH_INT35        (0x00000008)
#define MCF_INTC_IPRH_INT36        (0x00000010)
#define MCF_INTC_IPRH_INT37        (0x00000020)
#define MCF_INTC_IPRH_INT38        (0x00000040)
#define MCF_INTC_IPRH_INT39        (0x00000080)
#define MCF_INTC_IPRH_INT40        (0x00000100)
#define MCF_INTC_IPRH_INT41        (0x00000200)
#define MCF_INTC_IPRH_INT42        (0x00000400)
#define MCF_INTC_IPRH_INT43        (0x00000800)
#define MCF_INTC_IPRH_INT44        (0x00001000)
#define MCF_INTC_IPRH_INT45        (0x00002000)
#define MCF_INTC_IPRH_INT46        (0x00004000)
#define MCF_INTC_IPRH_INT47        (0x00008000)
#define MCF_INTC_IPRH_INT48        (0x00010000)
#define MCF_INTC_IPRH_INT49        (0x00020000)
#define MCF_INTC_IPRH_INT50        (0x00040000)
#define MCF_INTC_IPRH_INT51        (0x00080000)
#define MCF_INTC_IPRH_INT52        (0x00100000)
#define MCF_INTC_IPRH_INT53        (0x00200000)
#define MCF_INTC_IPRH_INT54        (0x00400000)
#define MCF_INTC_IPRH_INT55        (0x00800000)
#define MCF_INTC_IPRH_INT56        (0x01000000)
#define MCF_INTC_IPRH_INT57        (0x02000000)
#define MCF_INTC_IPRH_INT58        (0x04000000)
#define MCF_INTC_IPRH_INT59        (0x08000000)
#define MCF_INTC_IPRH_INT60        (0x10000000)
#define MCF_INTC_IPRH_INT61        (0x20000000)
#define MCF_INTC_IPRH_INT62        (0x40000000)
#define MCF_INTC_IPRH_INT63        (0x80000000)

/* Bit definitions and macros for MCF_INTC_IPRL */
#define MCF_INTC_IPRL_INT1         (0x00000002)
#define MCF_INTC_IPRL_INT2         (0x00000004)
#define MCF_INTC_IPRL_INT3         (0x00000008)
#define MCF_INTC_IPRL_INT4         (0x00000010)
#define MCF_INTC_IPRL_INT5         (0x00000020)
#define MCF_INTC_IPRL_INT6         (0x00000040)
#define MCF_INTC_IPRL_INT7         (0x00000080)
#define MCF_INTC_IPRL_INT8         (0x00000100)
#define MCF_INTC_IPRL_INT9         (0x00000200)
#define MCF_INTC_IPRL_INT10        (0x00000400)
#define MCF_INTC_IPRL_INT11        (0x00000800)
#define MCF_INTC_IPRL_INT12        (0x00001000)
#define MCF_INTC_IPRL_INT13        (0x00002000)
#define MCF_INTC_IPRL_INT14        (0x00004000)
#define MCF_INTC_IPRL_INT15        (0x00008000)
#define MCF_INTC_IPRL_INT16        (0x00010000)
#define MCF_INTC_IPRL_INT17        (0x00020000)
#define MCF_INTC_IPRL_INT18        (0x00040000)
#define MCF_INTC_IPRL_INT19        (0x00080000)
#define MCF_INTC_IPRL_INT20        (0x00100000)
#define MCF_INTC_IPRL_INT21        (0x00200000)
#define MCF_INTC_IPRL_INT22        (0x00400000)
#define MCF_INTC_IPRL_INT23        (0x00800000)
#define MCF_INTC_IPRL_INT24        (0x01000000)
#define MCF_INTC_IPRL_INT25        (0x02000000)
#define MCF_INTC_IPRL_INT26        (0x04000000)
#define MCF_INTC_IPRL_INT27        (0x08000000)
#define MCF_INTC_IPRL_INT28        (0x10000000)
#define MCF_INTC_IPRL_INT29        (0x20000000)
#define MCF_INTC_IPRL_INT30        (0x40000000)
#define MCF_INTC_IPRL_INT31        (0x80000000)

/* Bit definitions and macros for MCF_INTC_IMRH */
#define MCF_INTC_IMRH_MASK32       (0x00000001)
#define MCF_INTC_IMRH_MASK33       (0x00000002)
#define MCF_INTC_IMRH_MASK34       (0x00000004)
#define MCF_INTC_IMRH_MASK35       (0x00000008)
#define MCF_INTC_IMRH_MASK36       (0x00000010)
#define MCF_INTC_IMRH_MASK37       (0x00000020)
#define MCF_INTC_IMRH_MASK38       (0x00000040)
#define MCF_INTC_IMRH_MASK39       (0x00000080)
#define MCF_INTC_IMRH_MASK40       (0x00000100)
#define MCF_INTC_IMRH_MASK41       (0x00000200)
#define MCF_INTC_IMRH_MASK42       (0x00000400)
#define MCF_INTC_IMRH_MASK43       (0x00000800)
#define MCF_INTC_IMRH_MASK44       (0x00001000)
#define MCF_INTC_IMRH_MASK45       (0x00002000)
#define MCF_INTC_IMRH_MASK46       (0x00004000)
#define MCF_INTC_IMRH_MASK47       (0x00008000)
#define MCF_INTC_IMRH_MASK48       (0x00010000)
#define MCF_INTC_IMRH_MASK49       (0x00020000)
#define MCF_INTC_IMRH_MASK50       (0x00040000)
#define MCF_INTC_IMRH_MASK51       (0x00080000)
#define MCF_INTC_IMRH_MASK52       (0x00100000)
#define MCF_INTC_IMRH_MASK53       (0x00200000)
#define MCF_INTC_IMRH_MASK54       (0x00400000)
#define MCF_INTC_IMRH_MASK55       (0x00800000)
#define MCF_INTC_IMRH_MASK56       (0x01000000)
#define MCF_INTC_IMRH_MASK57       (0x02000000)
#define MCF_INTC_IMRH_MASK58       (0x04000000)
#define MCF_INTC_IMRH_MASK59       (0x08000000)
#define MCF_INTC_IMRH_MASK60       (0x10000000)
#define MCF_INTC_IMRH_MASK61       (0x20000000)
#define MCF_INTC_IMRH_MASK62       (0x40000000)
#define MCF_INTC_IMRH_MASK63       (0x80000000)

/* Bit definitions and macros for MCF_INTC_IMRL */
#define MCF_INTC_IMRL_MASKALL      (0x00000001)
#define MCF_INTC_IMRL_MASK1        (0x00000002)
#define MCF_INTC_IMRL_MASK2        (0x00000004)
#define MCF_INTC_IMRL_MASK3        (0x00000008)
#define MCF_INTC_IMRL_MASK4        (0x00000010)
#define MCF_INTC_IMRL_MASK5        (0x00000020)
#define MCF_INTC_IMRL_MASK6        (0x00000040)
#define MCF_INTC_IMRL_MASK7        (0x00000080)
#define MCF_INTC_IMRL_MASK8        (0x00000100)
#define MCF_INTC_IMRL_MASK9        (0x00000200)
#define MCF_INTC_IMRL_MASK10       (0x00000400)
#define MCF_INTC_IMRL_MASK11       (0x00000800)
#define MCF_INTC_IMRL_MASK12       (0x00001000)
#define MCF_INTC_IMRL_MASK13       (0x00002000)
#define MCF_INTC_IMRL_MASK14       (0x00004000)
#define MCF_INTC_IMRL_MASK15       (0x00008000)
#define MCF_INTC_IMRL_MASK16       (0x00010000)
#define MCF_INTC_IMRL_MASK17       (0x00020000)
#define MCF_INTC_IMRL_MASK18       (0x00040000)
#define MCF_INTC_IMRL_MASK19       (0x00080000)
#define MCF_INTC_IMRL_MASK20       (0x00100000)
#define MCF_INTC_IMRL_MASK21       (0x00200000)
#define MCF_INTC_IMRL_MASK22       (0x00400000)
#define MCF_INTC_IMRL_MASK23       (0x00800000)
#define MCF_INTC_IMRL_MASK24       (0x01000000)
#define MCF_INTC_IMRL_MASK25       (0x02000000)
#define MCF_INTC_IMRL_MASK26       (0x04000000)
#define MCF_INTC_IMRL_MASK27       (0x08000000)
#define MCF_INTC_IMRL_MASK28       (0x10000000)
#define MCF_INTC_IMRL_MASK29       (0x20000000)
#define MCF_INTC_IMRL_MASK30       (0x40000000)
#define MCF_INTC_IMRL_MASK31       (0x80000000)

/* Bit definitions and macros for MCF_INTC_INTFRCH */
#define MCF_INTC_INTFRCH_INTFRC32  (0x00000001)
#define MCF_INTC_INTFRCH_INTFRC33  (0x00000002)
#define MCF_INTC_INTFRCH_INTFRC34  (0x00000004)
#define MCF_INTC_INTFRCH_INTFRC35  (0x00000008)
#define MCF_INTC_INTFRCH_INTFRC36  (0x00000010)
#define MCF_INTC_INTFRCH_INTFRC37  (0x00000020)
#define MCF_INTC_INTFRCH_INTFRC38  (0x00000040)
#define MCF_INTC_INTFRCH_INTFRC39  (0x00000080)
#define MCF_INTC_INTFRCH_INTFRC40  (0x00000100)
#define MCF_INTC_INTFRCH_INTFRC41  (0x00000200)
#define MCF_INTC_INTFRCH_INTFRC42  (0x00000400)
#define MCF_INTC_INTFRCH_INTFRC43  (0x00000800)
#define MCF_INTC_INTFRCH_INTFRC44  (0x00001000)
#define MCF_INTC_INTFRCH_INTFRC45  (0x00002000)
#define MCF_INTC_INTFRCH_INTFRC46  (0x00004000)
#define MCF_INTC_INTFRCH_INTFRC47  (0x00008000)
#define MCF_INTC_INTFRCH_INTFRC48  (0x00010000)
#define MCF_INTC_INTFRCH_INTFRC49  (0x00020000)
#define MCF_INTC_INTFRCH_INTFRC50  (0x00040000)
#define MCF_INTC_INTFRCH_INTFRC51  (0x00080000)
#define MCF_INTC_INTFRCH_INTFRC52  (0x00100000)
#define MCF_INTC_INTFRCH_INTFRC53  (0x00200000)
#define MCF_INTC_INTFRCH_INTFRC54  (0x00400000)
#define MCF_INTC_INTFRCH_INTFRC55  (0x00800000)
#define MCF_INTC_INTFRCH_INTFRC56  (0x01000000)
#define MCF_INTC_INTFRCH_INTFRC57  (0x02000000)
#define MCF_INTC_INTFRCH_INTFRC58  (0x04000000)
#define MCF_INTC_INTFRCH_INTFRC59  (0x08000000)
#define MCF_INTC_INTFRCH_INTFRC60  (0x10000000)
#define MCF_INTC_INTFRCH_INTFRC61  (0x20000000)
#define MCF_INTC_INTFRCH_INTFRC62  (0x40000000)
#define MCF_INTC_INTFRCH_INTFRC63  (0x80000000)

/* Bit definitions and macros for MCF_INTC_INTFRCL */
#define MCF_INTC_INTFRCL_INTFRC1   (0x00000002)
#define MCF_INTC_INTFRCL_INTFRC2   (0x00000004)
#define MCF_INTC_INTFRCL_INTFRC3   (0x00000008)
#define MCF_INTC_INTFRCL_INTFRC4   (0x00000010)
#define MCF_INTC_INTFRCL_INTFRC5   (0x00000020)
#define MCF_INTC_INTFRCL_INTFRC6   (0x00000040)
#define MCF_INTC_INTFRCL_INTFRC7   (0x00000080)
#define MCF_INTC_INTFRCL_INTFRC8   (0x00000100)
#define MCF_INTC_INTFRCL_INTFRC9   (0x00000200)
#define MCF_INTC_INTFRCL_INTFRC10  (0x00000400)
#define MCF_INTC_INTFRCL_INTFRC11  (0x00000800)
#define MCF_INTC_INTFRCL_INTFRC12  (0x00001000)
#define MCF_INTC_INTFRCL_INTFRC13  (0x00002000)
#define MCF_INTC_INTFRCL_INTFRC14  (0x00004000)
#define MCF_INTC_INTFRCL_INTFRC15  (0x00008000)
#define MCF_INTC_INTFRCL_INTFRC16  (0x00010000)
#define MCF_INTC_INTFRCL_INTFRC17  (0x00020000)
#define MCF_INTC_INTFRCL_INTFRC18  (0x00040000)
#define MCF_INTC_INTFRCL_INTFRC19  (0x00080000)
#define MCF_INTC_INTFRCL_INTFRC20  (0x00100000)
#define MCF_INTC_INTFRCL_INTFRC21  (0x00200000)
#define MCF_INTC_INTFRCL_INTFRC22  (0x00400000)
#define MCF_INTC_INTFRCL_INTFRC23  (0x00800000)
#define MCF_INTC_INTFRCL_INTFRC24  (0x01000000)
#define MCF_INTC_INTFRCL_INTFRC25  (0x02000000)
#define MCF_INTC_INTFRCL_INTFRC26  (0x04000000)
#define MCF_INTC_INTFRCL_INTFRC27  (0x08000000)
#define MCF_INTC_INTFRCL_INTFRC28  (0x10000000)
#define MCF_INTC_INTFRCL_INTFRC29  (0x20000000)
#define MCF_INTC_INTFRCL_INTFRC30  (0x40000000)
#define MCF_INTC_INTFRCL_INTFRC31  (0x80000000)

/* Bit definitions and macros for MCF_INTC_IRLR */
#define MCF_INTC_IRLR_IRQ(x)       (((x)&0x7F)<<1)

/* Bit definitions and macros for MCF_INTC_IACKLPR */
#define MCF_INTC_IACKLPR_PRI(x)    (((x)&0x0F)<<0)
#define MCF_INTC_IACKLPR_LEVEL(x)  (((x)&0x07)<<4)

/* Bit definitions and macros for MCF_INTC_ICR */
#define MCF_INTC_ICR_IP(x)         (((x)&0x07)<<0)
#define MCF_INTC_ICR_IL(x)         (((x)&0x07)<<3)

/* Bit definitions and macros for MCF_INTC_SWIACK */
#define MCF_INTC_SWIACK_VECTOR(x)  (((x)&0xFF)<<0)

/* Bit definitions and macros for MCF_INTC_LIACK */
#define MCF_INTC_LIACK_VECTOR(x)   (((x)&0xFF)<<0)

/********************************************************************/

#endif /* __MCF5223_INTC_H__ */
