/*
 * File:		mcf52xx.c
 * Purpose:		Source to select CF derivative
 *
 * Notes:
 */
/********************************************************************/
#include "opentcp.h"


void Leds_Init(void){

	MCF_GPIO_PTCPAR = 0x00; // gpio
	MCF_GPIO_DDRTC  = 0x0f; // output
	MCF_GPIO_PORTTC = 0x00; // TURN LEDS OFF
}

void Timer_Init(void){

	/* Set 10 ms tic for OpenTCP timers	*/

//	MCF_PIT_PCSR0  = MCF_PIT_PCSR_PRE(0x06);	/* Divide system clock/2 by 2^x (60) --> 1us/tic	*/
	MCF_PIT_PCSR0  = MCF_PIT_PCSR_PRE(0x07);	/* Divide system clock/2 by 2^x (90) --> 1us/tic	*/
	MCF_INTC0_ICR55 = MCF_INTC_ICR_IL(TIMER_NETWORK_LEVEL);
	MCF_INTC0_IMRH &= ~MCF_INTC_IMRH_MASK55;
//	MCF_PIT_PMR0 = 500;						/* Interrupt every 1 ms @ 60 MHz	*/
	MCF_PIT_PMR0 = 350;						/* Interrupt every 1 ms @ 90 MHz	*/
	MCF_PIT_PCSR0 |= MCF_PIT_PCSR_OVW | MCF_PIT_PCSR_PIE |
	                 MCF_PIT_PCSR_PIF | MCF_PIT_PCSR_RLD |
	                 MCF_PIT_PCSR_EN;
}
/********************************************************************/
/*
 * irq1 Handler
 */
__interrupt__ void
irq1_handler(void)
{
	printf("\nirq one.   - ");
    /* Wait for the switch to deassert */
    while (!(MCF_EPORT_EPPDR0 & MCF_EPORT_EPPDR_EPPD1)) {};
	sw3_handler();
    /* Clear the interrupt event */
    MCF_EPORT_EPFR0 = MCF_EPORT_EPFR0 | MCF_EPORT_EPFR_EPF1;
	printf("\n");
}
/********************************************************************/
/*
 * irq4 Handler
 */
__interrupt__ void
irq4_handler(void)
{
	printf("\nirq four.  - ");
    /* Wait for the switch to deassert */
    while (!(MCF_EPORT_EPPDR0 & MCF_EPORT_EPPDR_EPPD4)) {};
	sw1_handler();
    /* Clear the interrupt event */
    MCF_EPORT_EPFR0 = MCF_EPORT_EPFR0 | MCF_EPORT_EPFR_EPF4;
	printf("\n");
}
/********************************************************************/
/*
 * irq7 Handler
 */
__interrupt__ void
irq7_handler(void)
{
	printf("\nirq seven. - ");
    /* Wait for the switch to deassert */
    while (!(MCF_EPORT_EPPDR0 & MCF_EPORT_EPPDR_EPPD7)) {};
	abort_handler();
    /* Clear the interrupt event */
    MCF_EPORT_EPFR0 = MCF_EPORT_EPFR0 | MCF_EPORT_EPFR_EPF7;
	printf("\n");
}
/********************************************************************/
/*
 * irq11 Handler
 */
__interrupt__ void
irq11_handler(void)
{
	printf("\nirq eleven.- ");
    /* Wait for the switch to deassert */
    while (!(MCF_EPORT_EPPDR1 & MCF_EPORT_EPPDR_EPPD11)) {};
	sw2_handler();
    /* Clear the interrupt event */
    MCF_EPORT_EPFR1 = MCF_EPORT_EPFR1 | MCF_EPORT_EPFR_EPF11;
	printf("\n");
}
/********************************************************************/
