//****************************************************************
// @doc
// @module TIME_OUT.h | Enthlt Deklarationen und Definitionen fr 
// die Timeout-Steuerung mittels Timerinterrupt.
// @end
//----------------------------------------------------------------
// Definitionen fuer MKS  !!
// Modulname:    $Source: C:/c51_buecher/Teil2/software/Inc_C51b/rcs/TIME_OUT_lib.H $
// User:         $Author: MEBA $
// Version:      $Name: $  $Revision: 1.1 $
// Datum:        $Date: 2001/02/03 09:55:41Z $
// Qualitt:     $State: Exp $
// Historie:
//==========
// $Log: TIME_OUT_lib.H $
// Revision 1.1  2001/02/03 09:55:41Z  MEBA
// Initial revision
//----------------------------------------------------------------

//***************************************************************
// Beschreibung:
//***************************************************************

//***************************************************************
// @type Definitionen | Definitionen und Deklarationen fr die
// Steuerung des Timout-Verhaltens mittels Timer
//***************************************************************
#define SEC  000000L   // @define SEC    | Definition fr einfache Parameterbergabe
#define MSEC 000       // @define MSEC   | Definition fr einfache Parameterbergabe
#define CLEAR        0 // @define CLEAR  | Lscht die vorhandene Timeout-berwachung
#define SET          1 // @define SAT    | Setzt eine Timeout-berwachung
#define PRESET       2 // @define PRESET | berschreibt die vorhandene Timeout-berwachung

#define ERR_TIME                 0x01 // @define ERR_TIME  | Timerzeit > Timerinterrupt
#define ERR_MSEC                 0x02 // @define ERR_MSEC  | Timerzeit > 65536 usec. bei intern
#define ERR_TIMER                0x03 // @define ERR_TIMER | Kein Timer ausgewhlt
#define ERR_SHARE                0x04 // @define ERR_SHARE | Timer schon initialisiert
#define ERR_NO_TIMER_RUN         0x05 // @define ERR_NO_TIMER_RUN | Timer mu zuerst initialisiert werden
#define ERR_TIMEOUT_IS_RUNNING   0x06 // @define ERR_TIMEOUT_IS_RUNNING | Timeout wird schon verwendet
#define ERR_TIMEOUT_NOT_POSSIBLE 0x07 // @define ERR_TIMEOUT_NOT_POSSIBLE | der Timeout ist nicht realisierbar
#define ERR_TIME_OUT             0xFF // @define ERR_TIME_OUT |
#define NO_FUNKTION              0x00 // @define NO_FUNKTION  |
#define SOFTRES                  0x01 // @define SOFTRES      |


//***************************************************************
// Deklarationen von Funktionen und Variablen
//***************************************************************
// @func
extern uchar uc_TimeIni(uint uiIntTime, uchar ucControl);
// @func
extern uchar uc_TimeOut(uint uiTimeOut);

// @globalv 
extern uchar data ucMessage;
// @globalv Zyklenzaehler
extern uchar data ucTimeZyklus; 
// @globalv 
extern bit        btTimeOut;
// @globalv 
#ifdef TIMEOUT_16BIT
  extern uint data uiTimeOut;
#else
  extern uchar data ucTimeOut;
#endif
// @globalv Variable fr Zeitintervall 
extern uint xdata uiTime_uSec;      

// Beispiele fr externer Takt. 
// !! Die Werte mssen in KHz angegeben werden. !!
// #define EXT_CLK    0.064  // fr RTC72421

#ifndef TIMER_EXTERN0
 #define TIMER_EXTERN0 DISABLE
#endif

#ifndef TIMER_EXTERN1
 #define TIMER_EXTERN1 DISABLE
#endif
	
#ifndef SOFT_WDT
 #define SOFT_WDT DISABLE
#endif



