//****************************************************************
// @doc
// @module TASTEN_LIB.h | Enthlt Definitionen und Deklaration fr 
// die Abfrage von einzelnen Tasten.
// @end
//----------------------------------------------------------------
// Definitionen fuer MKS  !!
// Modulname:    $Source: C:/c51_buecher/Teil2/software/Inc_C51b/rcs/TASTEN_LIB.H $
// User:         $Author: MEBA $
// Version:      $Name: $  $Revision: 1.1 $
// Datum:        $Date: 2001/02/03 09:55:46Z $
// Qualitt:     $State: Exp $
// Historie:
//==========
// $Log: TASTEN_LIB.H $
// Revision 1.1  2001/02/03 09:55:46Z  MEBA
// Initial revision
//----------------------------------------------------------------

//***************************************************************
// Beschreibung: TASTEN_LIB.H
// 
//***************************************************************
#ifndef TASTEN_LIB_H
  #define TASTEN_LIB_H

//***************************************************************
// Definitionen der verwendeten Tasten
//***************************************************************
// @type Tasten-Definitionen | Definition der bentigten Tasten
// sowie der Tastenbelegung
//***************************************************************
#define ESC_KEY           1 // @define ESC_KEY    | Definition der ESC-Taste
#define UP_KEY            2 // @define UP_KEY     | Definition der UP-Taste
#define DOWN_KEY          3 // @define DOWN_KEY   | Definition der DOWN-Taste
#define RET_KEY           4 // @define RET_KEY    | Definition der RET-Taste
#define KEY_CLOSED        0 // @define KEY_CLOSED | Definition des geschlossenen Tastenzustandes
#define KEY_OPEN          1 // @define KEY_OPEN   | Definition des offenen Tastenzustandes

// Die hier aufgefuehrten Definitionen koennen nur dann eingesetzt werden,
// wenn die (Matrix)-Tastatur an einem Port angeschlossen wird.
#define USED_KEY_PORT    P1 // @define USED_KEY_PORT | Angabe des verwendeten Ports
#define KEY_ROW0  B11101111 // @define KEY_ROW0   | Defintion der Zeile  0
#define KEY_ROW1  B11011111 // @define KEY_ROW1   | Defintion der Zeile  1
#define KEY_ROW2  B10111111 // @define KEY_ROW2   | Defintion der Zeile  2
#define KEY_ROW3  B01111111 // @define KEY_ROW3   | Defintion der Zeile  3
#define KEY_COL0  B11111110 // @define KEY_COL0   | Defintion der Spalte 0
#define KEY_COL1  B11111101 // @define KEY_COL1   | Defintion der Spalte 1
#define KEY_COL2  B11111011 // @define KEY_COL2   | Defintion der Spalte 2
#define KEY_COL3  B11110111 // @define KEY_COL3   | Defintion der Spalte 3

sbit sbKEY1 = USED_KEY_PORT^0;
sbit sbKEY2 = USED_KEY_PORT^1;
sbit sbKEY3 = USED_KEY_PORT^2;
sbit sbKEY4 = USED_KEY_PORT^3;

// @type TastaturInterrupt | Definition der bentigten Tasten
// Wird fuer die Abfrage der Tastatur ein Interrupt verwendet, mu hier
// die Interrupt-Nummer angegeben werden.
#define TAST_INT EXT_INT3 // @define TAST_INT | Definition des verwendeten
                          // Tastaturinterrupts

//***************************************************************
// Deklarationen von Funktionen und Variablen
//***************************************************************
// @func
extern uc_WaitforKeyPress(uchar ucKeyNumber);
// @func
extern void v_TastInit(void);

#endif

