//***************************************************************
// Modulname:    $Source: C:/c51_buecher/Teil2/software/Inc_C51b/rcs/RS232_BD.h $
// User:         $Author: MEBA $
// Version:      $Name: $  $Revision: 1.1 $
// Datum:        $Date: 2001/02/03 09:55:46Z $
// Qualitt:     $State: Exp $
//***************************************************************
// Beschreibung: RS232.H Definitionen fuer den UART
//***************************************************************
// Historie:
//==========
// $Log: RS232_BD.h $
// Revision 1.1  2001/02/03 09:55:46Z  MEBA
// Initial revision
//***************************************************************
#ifndef RS232_H
  #define RS232_H

//***************************************************************
// verwendete Definitionen
//***************************************************************
// Definitionen fuer Uebergabeparameter ucUARTMode
#define UART       B00000001    // welcher UART wird verwendet
#define UART_1     B00000000    // erste serielle Schnittstelle
#define UART_2     B00000001    // zweite serielle Schnittstelle z.B. 80C517(A)
#define BIT_RATE   B11000000    
#define _8BIT      B01000000
#define _9BIT      B11000000
#define PARITY     B00001100
#define NO_PAR     B00000000
#define EV_PAR     B00000100
#define ODD_PAR    B00001000
#define STOPBIT    B00001100
#define MULTI_SYS  B00100000
#define MULTI_OFF  B00000000
#define MULTI_ON   B00100000



#define NO_START_VALUE_RS232 0xFF
#define NO_STOP_VALUE_RS232  0xFE
#define PARITY_ERR_RS232     0xFD 
#define BAUD_FRAME_ERROR     0xFC
#define READ_RS232              1
#define WRITE_RS232             0

#define HIGH 1
#define LOW  0
#define NO   0
#define YES  1

#define BAUDRATE_TOLERANZ 2  // Abweichung pro Byte max. 5%


//***************************************************************
// Deklarationen von Funktionen und Variablen
//***************************************************************
extern uchar ucError;

extern uchar uc_Init_UART1_BDfix(ulong ulBaudrate, uchar ucUARTMode);


#endif

