//****************************************************************
// @doc
// @module MAKROS.h | Enthlt Makros und Deklarationen von Unions.
// @end
//----------------------------------------------------------------
// Definitionen fuer MKS  !!
// Modulname:    $Source: C:/c51_buecher/Teil2/software/Inc_C51b/rcs/MAKROS.H $
// User:         $Author: MEBA $
// Version:      $Name: $  $Revision: 1.1 $
// Datum:        $Date: 2001/02/03 09:55:44Z $
// Qualitt:     $State: Exp $
// @type Historie: | Folgende Aenderungen wurden vorgenommen:
// 04.01.2001 Da die H-Files auch in Assembler-Modulen eingesetzt
// werden koennen, muessen C spezifische Eigenschaften mittels ifdef
// Abfragen auskommentiert werden. 
// 06.01.2001 Die Unions wurden an die ungarische Notation angepasst.
// Es wurde zudem eine 24 Bit union fr die Verarbeitung von Pointern
// eingefgt.
//==========
// $Log: MAKROS.H $
// Revision 1.1  2001/02/03 09:55:44Z  MEBA
// Initial revision
//----------------------------------------------------------------

//***************************************************************
// @type Allgemeine Definitionen | Folgende Makros sind zur definiert:.
//***************************************************************
#ifndef MAKROS_H
 #define  MAKROS_H
// @define ABSDIFF |
#define ABSDIFF(a,b)          (((a) > (b)) ? (a)-(b) :(b) - (a))

// @define MAX |
#define MAX(a,b)              (((a) > (b)) ? (a) : (b))    

// @define HIGH2LOW |
#define HIGH2LOW(a)         ((unsigned char) (( a ) >> 8))

// @define LOW2HIGH |
#define LOW2HIGH(a)         (((unsigned int) a <<8)) 

// @define SQUARE |
#define SQUARE(x)             ((x) * (x))

// @define UNITE_2CHAR_INT |
#define UNITE_2CHAR_INT(a, b) ((((unsigned int) a) <<8) | b)

// @define CLEAR_BIT |
#define CLEAR_BIT(SFRAddress,Bitaddress) (SFRAddress&=(~Bitaddress))

// @define SET_BIT |
#define   SET_BIT(SFRAddress,Bitaddress) (SFRAddress|=(Bitaddress))

// @define IS_BIT_SET |
#define IS_BIT_SET(SFRAddress,Bitaddress) (SFRAddress&Bitaddress)

//***************************************************************
// @type Deklaration von Unions | Folgende Unions sind zur Zeit 
// vorhanden:
//***************************************************************
#ifndef __A51__
	union _32bit {  // union _32bit |
	     ulong ulA;
	     uint  auiA[2];
	     uchar aucA[4]; 
	   };
	
	union _24bit { // union _24bit |
	   uint uiA;
	   uint aucA[3];
	   void *vpPtr;
	}; 

	union _16bit { // union _16bit |
	   uint uiA;
	   uint aucA[2];
	}; 
#endif

#endif
